/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.Future;
import org.ferris.yahoo.finance.jmce.bean.Gold;
import org.ferris.yahoo.finance.jmce.bean.YearEndPrice;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerByScrape;
import org.ferris.yahoo.finance.jmce.handler.CalendarHandler;
import org.ferris.yahoo.finance.jmce.handler.CmeGroupHandler;
import org.ferris.yahoo.finance.jmce.handler.GoldHandler;
import org.ferris.yahoo.finance.jmce.net.HtmlPageContents;

public class GoldHandlerByScrape
extends AbstractHandlerByScrape
implements GoldHandler {
    private static final Logger log = Logger.getLogger(GoldHandlerByScrape.class);
    private CalendarHandler calendarHandler;
    private CmeGroupHandler cmeGroupHandler;

    @Override
    public Gold getByCurrentContract() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getByCurrentContract()", new Object[0]));
        }
        try {
            Future future = this.getCmeGroupHandler().getGreatestOpenInterestFutureForGold();
            String tickerAndMonth = future.getTicker().substring(0, 3);
            String year = future.getTicker().substring(3);
            if (year.length() == 1) {
                year = "1" + year;
            }
            String yahooTickerSymbol = String.format("%s%s.cmx", tickerAndMonth, year).toLowerCase();
            HtmlPageContents pageContents = this.getHtmlPageContents(String.format("http://finance.yahoo.com/q?s=%s", yahooTickerSymbol));
            String value = pageContents.getContentsOfTagByIds(String.format("yfs_l10_%s", yahooTickerSymbol));
            String valueChange = pageContents.getContentsOfTagByIds(String.format("yfs_c10_%s", yahooTickerSymbol));
            String percentageChange = pageContents.getContentsOfTagByIds(String.format("yfs_p20_%s", yahooTickerSymbol));
            valueChange = String.format("%s%s", this.getMarketDown(pageContents), valueChange);
            percentageChange = String.format("%s%s", this.getMarketDown(pageContents), percentageChange);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Create Gold bean and set data", new Object[0]));
            }
            Gold bean = new Gold();
            bean.setName(String.format("%s (%s)", bean.getName(), yahooTickerSymbol));
            bean.setPriceAtEndOfDay(DecimalFormat.getNumberInstance().parse(value).doubleValue());
            bean.setPriceChangeSinceYesterday(valueChange);
            bean.setPercentageChangeSinceYesterday(percentageChange);
            YearEndPrice yearEndPrice = this.getYearEndPriceHandler().getYearEndPriceForOil(this.getCalendarHandler().getLastYear());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Year end price \"%s\"", String.valueOf(yearEndPrice)));
            }
            if (yearEndPrice != null) {
                bean.setPriceAtEndOfLastYear(yearEndPrice.getPrice().doubleValue());
            }
            return bean;
        }
        catch (Throwable t) {
            log.fatal((Object)"Couldn't get gold by current contract", t);
            throw new RuntimeException(t);
        }
    }

    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    public void setCalendarHandler(CalendarHandler calendarHandler) {
        this.calendarHandler = calendarHandler;
    }

    public CmeGroupHandler getCmeGroupHandler() {
        return this.cmeGroupHandler;
    }

    public void setCmeGroupHandler(CmeGroupHandler cmeGroupHandler) {
        this.cmeGroupHandler = cmeGroupHandler;
    }
}

