/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.EmailAddress;
import org.ferris.yahoo.finance.jmce.bean.Message;
import org.ferris.yahoo.finance.jmce.handler.CalendarHandler;
import org.ferris.yahoo.finance.jmce.handler.EmailAddressHandler;
import org.ferris.yahoo.finance.jmce.handler.MessageHandler;
import org.ferris.yahoo.finance.jmce.mail.SimpleMailMessage;

public class MessageHandlerBySmtp
implements MessageHandler {
    private static final Logger log = Logger.getLogger(MessageHandlerBySmtp.class);
    private EmailAddressHandler emailAddressHandler;
    private CalendarHandler calendarHandler;

    @Override
    public void mailAdmin(Message message) {
        EmailAddress from = this.getEmailAddressHandler().getFrom();
        EmailAddress replyTo = this.getEmailAddressHandler().getReplyTo();
        EmailAddress to = this.getEmailAddressHandler().getAdmin();
        Date now = this.calendarHandler.getNow().getTime();
        SimpleMailMessage mailer = new SimpleMailMessage("localhost");
        mailer.setSendDate(now);
        mailer.setFrom(from);
        mailer.setReplyTo(replyTo);
        mailer.addTo(to);
        mailer.setSubject(String.format("Yahoo! Finance JMCE Scrapper Error on %s", new SimpleDateFormat("MM/dd").format(now)));
        mailer.setText(message.toString());
        mailer.send();
    }

    @Override
    public void mailMessage(Message message) {
        EmailAddress from = this.getEmailAddressHandler().getFrom();
        EmailAddress replyTo = this.getEmailAddressHandler().getReplyTo();
        List<EmailAddress> to = this.getEmailAddressHandler().getTo();
        List<EmailAddress> bcc = this.getEmailAddressHandler().getBcc();
        List<EmailAddress> cc = this.getEmailAddressHandler().getCc();
        Date now = this.calendarHandler.getNow().getTime();
        SimpleMailMessage mailer = new SimpleMailMessage("localhost");
        mailer.setSendDate(now);
        mailer.setFrom(from);
        mailer.setReplyTo(replyTo);
        mailer.addTo(to.toArray(new EmailAddress[0]));
        mailer.addBcc(bcc.toArray(new EmailAddress[0]));
        mailer.addCc(cc.toArray(new EmailAddress[0]));
        mailer.setSubject(String.format("Daily Market Summary for %s", new SimpleDateFormat("MM/dd").format(now)));
        mailer.setText(message.toString());
        mailer.send();
    }

    public EmailAddressHandler getEmailAddressHandler() {
        return this.emailAddressHandler;
    }

    public void setEmailAddressHandler(EmailAddressHandler emailAddressHandler) {
        this.emailAddressHandler = emailAddressHandler;
    }

    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    public void setCalendarHandler(CalendarHandler calendarHandler) {
        this.calendarHandler = calendarHandler;
    }
}

