/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.text.DecimalFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.Nasdaq;
import org.ferris.yahoo.finance.jmce.bean.YearEndPrice;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerByScrape;
import org.ferris.yahoo.finance.jmce.handler.NasdaqHandler;
import org.ferris.yahoo.finance.jmce.net.HtmlPageContents;

public class NasdaqHandlerByScrape
extends AbstractHandlerByScrape
implements NasdaqHandler {
    private static final Logger log = Logger.getLogger(NasdaqHandlerByScrape.class);

    @Override
    public Nasdaq getById(String id) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getById(%s)", id));
        }
        try {
            HtmlPageContents pageContents = this.getHtmlPageContents(id);
            String value = pageContents.getContentsOfTagByIds("yfs_l10_^ixic");
            String valueChange = pageContents.getContentsOfTagByIds("yfs_c10_^ixic", "yfs_c10_^ixic");
            String percentageChange = pageContents.getContentsOfTagByIds("yfs_p20_^ixic", "yfs_p20_^ixic");
            valueChange = String.format("%s%s", this.getMarketDown(pageContents), valueChange);
            percentageChange = String.format("%s%s", this.getMarketDown(pageContents), percentageChange);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Create Nasdaq bean and set data", new Object[0]));
            }
            Nasdaq bean = new Nasdaq();
            bean.setPriceAtEndOfDay(DecimalFormat.getNumberInstance().parse(value).doubleValue());
            bean.setPriceChangeSinceYesterday(valueChange);
            bean.setPercentageChangeSinceYesterday(percentageChange);
            YearEndPrice yearEndPrice = this.getYearEndPriceHandler().getYearEndPriceForNasdaq(Calendar.getInstance().get(1) - 1);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Year end price \"%s\"", String.valueOf(yearEndPrice)));
            }
            if (yearEndPrice != null) {
                bean.setPriceAtEndOfLastYear(yearEndPrice.getPrice().doubleValue());
            }
            return bean;
        }
        catch (Throwable t) {
            log.fatal((Object)"Couldn't get nasdaq by id", t);
            throw new RuntimeException(t);
        }
    }
}

