/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.text.DecimalFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.StandardAndPoors500;
import org.ferris.yahoo.finance.jmce.bean.YearEndPrice;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerByScrape;
import org.ferris.yahoo.finance.jmce.handler.StandardAndPoors500Handler;
import org.ferris.yahoo.finance.jmce.net.HtmlPageContents;

public class StandardAndPoors500HandlerByScrape
extends AbstractHandlerByScrape
implements StandardAndPoors500Handler {
    private static final Logger log = Logger.getLogger(StandardAndPoors500HandlerByScrape.class);

    @Override
    public StandardAndPoors500 getById(String id) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getById(%s)", id));
        }
        try {
            HtmlPageContents pageContents = this.getHtmlPageContents(id);
            String value = pageContents.getContentsOfTagByIds("yfs_l10_^gspc");
            String valueChange = pageContents.getContentsOfTagByIds("yfs_l10_^gspc", "yfs_c10_^gspc");
            String percentageChange = pageContents.getContentsOfTagByIds("yfs_l10_^gspc", "yfs_p20_^gspc");
            valueChange = String.format("%s%s", this.getMarketDown(pageContents), valueChange);
            percentageChange = String.format("%s%s", this.getMarketDown(pageContents), percentageChange);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Create StandardAndPoors500 bean and set data", new Object[0]));
            }
            StandardAndPoors500 bean = new StandardAndPoors500();
            bean.setPriceAtEndOfDay(DecimalFormat.getNumberInstance().parse(value).doubleValue());
            bean.setPriceChangeSinceYesterday(valueChange);
            bean.setPercentageChangeSinceYesterday(percentageChange);
            YearEndPrice yearEndPrice = this.getYearEndPriceHandler().getYearEndPriceForStandardAndPoors500(Calendar.getInstance().get(1) - 1);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Year end price \"%s\"", String.valueOf(yearEndPrice)));
            }
            if (yearEndPrice != null) {
                bean.setPriceAtEndOfLastYear(yearEndPrice.getPrice().doubleValue());
            }
            return bean;
        }
        catch (Throwable t) {
            log.fatal((Object)"Couldn't get S&P500 by id", t);
            throw new RuntimeException(t);
        }
    }
}

