/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.Market;
import org.ferris.yahoo.finance.jmce.bean.YearEndPrice;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerBySql;
import org.ferris.yahoo.finance.jmce.handler.CalendarHandler;
import org.ferris.yahoo.finance.jmce.handler.PrimaryKeyHandler;
import org.ferris.yahoo.finance.jmce.handler.YearEndPriceHandler;

public class YearEndPriceHandlerBySql
extends AbstractHandlerBySql
implements YearEndPriceHandler {
    private static final Logger log = Logger.getLogger(YearEndPriceHandlerBySql.class);
    public CalendarHandler calendarHandler;
    private PrimaryKeyHandler primaryKeyHandler;

    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    public void setCalendarHandler(CalendarHandler calendarHandler) {
        this.calendarHandler = calendarHandler;
    }

    public PrimaryKeyHandler getPrimaryKeyHandler() {
        return this.primaryKeyHandler;
    }

    public void setPrimaryKeyHandler(PrimaryKeyHandler primaryKeyHandler) {
        this.primaryKeyHandler = primaryKeyHandler;
    }

    @Override
    public YearEndPrice getYearEndPriceForGold(int year) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getYearEndPriceForGold(%d)", year));
        }
        return this.getYearEndPriceForMarket(year, Market.Code.gc);
    }

    @Override
    public YearEndPrice getYearEndPriceForOil(int year) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getYearEndPriceForOil(%d)", year));
        }
        return this.getYearEndPriceForMarket(year, Market.Code.cl);
    }

    @Override
    public YearEndPrice getYearEndPriceForStandardAndPoors500(int year) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getYearEndPriceForStandardAndPoors500(%d)", year));
        }
        return this.getYearEndPriceForMarket(year, Market.Code.sp);
    }

    @Override
    public YearEndPrice getYearEndPriceForNasdaq(int year) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getYearEndPriceForNasdaq(%d)", year));
        }
        return this.getYearEndPriceForMarket(year, Market.Code.nas);
    }

    @Override
    public YearEndPrice getYearEndPriceForDow(int year) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getYearEndPriceForDow(%d)", year));
        }
        return this.getYearEndPriceForMarket(year, Market.Code.dow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YearEndPrice getYearEndPriceForMarket(int year, Market.Code marketCode) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getYearEndPriceForMarket(%d,%s)", new Object[]{year, marketCode}));
        }
        StringBuilder sp = new StringBuilder();
        sp.append(String.format(" select ", new Object[0]));
        sp.append(String.format("\t\tyep.id, yep.created_on, yep.updated_on, m.id as market_id, yep.year, yep.price ", new Object[0]));
        sp.append(String.format(" from ", new Object[0]));
        sp.append(String.format("   year_end_prices yep ", new Object[0]));
        sp.append(String.format(" , markets m ", new Object[0]));
        sp.append(String.format(" where ", new Object[0]));
        sp.append(String.format("\t\tyep.market_ptr=m.id ", new Object[0]));
        sp.append(String.format("\t\tand ", new Object[0]));
        sp.append(String.format("\t\tyep.market_ptr=(select id from markets where code=?) ", new Object[0]));
        sp.append(String.format("\t\tand ", new Object[0]));
        sp.append(String.format("\t\tyep.year = ? ", new Object[0]));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        YearEndPrice bean = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sp.toString());
            this.setString(stmt, 1, marketCode.toString());
            this.setInt(stmt, 2, year);
            rs = this.executeQuery(stmt);
            bean = this.getBean(rs);
        }
        catch (Throwable throwable) {
            this.close(conn, stmt, rs);
            throw throwable;
        }
        this.close(conn, stmt, rs);
        return bean;
    }

    private YearEndPrice getBean(ResultSet rs) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getBean()", new Object[0]));
        }
        YearEndPrice bean = null;
        try {
            if (!rs.next()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("ResultSet is empty!", new Object[0]));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("ResultSet has record so building bean", new Object[0]));
                }
                String id = rs.getString("id");
                Calendar createdOn = Calendar.getInstance();
                createdOn.setTimeInMillis(rs.getTimestamp("created_on").getTime());
                Calendar updatedOn = Calendar.getInstance();
                createdOn.setTimeInMillis(rs.getTimestamp("updated_on").getTime());
                String marketId = rs.getString("market_id");
                int year = rs.getInt("year");
                BigDecimal price = rs.getBigDecimal("price");
                bean = new YearEndPrice(id, createdOn, updatedOn, marketId, year, price);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Returning Bean=\"%s\" with id=\"%s\"", bean.getClass().getSimpleName(), bean.getId()));
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem getting YearEndPrice bean", t);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setYearEndPriceForMarket(double price, int year, Market.Code marketCode) {
        PreparedStatement stmt;
        Connection conn;
        block4: {
            boolean lastDayOfYear;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("ENTER setYearEndPriceForMarket(%f, %d,%s)", new Object[]{price, year, marketCode}));
            }
            if (!(lastDayOfYear = this.getCalendarHandler().isNowTheLastDayOfTheYear())) {
                log.info((Object)String.format("Today is not the last day of the year...NOT saving (%f, %d,%s)", new Object[]{price, year, marketCode}));
                return;
            }
            log.info((Object)String.format("Yey...last day of the year!!!", new Object[0]));
            StringBuilder sp = new StringBuilder();
            sp.append(String.format(" insert into year_end_prices ", new Object[0]));
            sp.append(String.format(" (id, created_on, updated_on, market_ptr, year, price) ", new Object[0]));
            sp.append(String.format(" values ", new Object[0]));
            sp.append(String.format(" (?, ?, ?, (select id from markets where code=?), ?, ?) ", new Object[0]));
            conn = null;
            stmt = null;
            try {
                conn = this.getConnection();
                stmt = this.prepareStatement(conn, sp.toString());
                int idx = 1;
                Calendar now = this.getCalendarHandler().getNow();
                this.setString(stmt, idx++, this.getPrimaryKeyHandler().getPrimaryKey());
                this.setTimestamp(stmt, idx++, now);
                this.setTimestamp(stmt, idx++, now);
                this.setString(stmt, idx++, marketCode.toString());
                this.setInt(stmt, idx++, year);
                this.setDouble(stmt, idx++, price);
                int updated = this.executeUpdate(stmt);
                if (!log.isInfoEnabled()) break block4;
                log.info((Object)String.format("ExcuteUpdate updated %d rows", updated));
            }
            catch (Throwable throwable) {
                this.close(conn, stmt, null);
                throw throwable;
            }
        }
        this.close(conn, stmt, null);
    }
}

