/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.mail;

import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.ferris.yahoo.finance.jmce.bean.EmailAddress;
import org.ferris.yahoo.finance.jmce.mail.ByteArrayDataSource;

public class SimpleMailMessage {
    private Session sendMailSession;
    private MimeMessage message;
    private String body;
    private Date date;

    private void addAddresses(Message.RecipientType type, EmailAddress ... to) {
        try {
            if (to != null) {
                for (EmailAddress address : to) {
                    this.message.addRecipient(type, (Address)new InternetAddress(address.getAddress(), address.getName()));
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    private void sendAsText() {
        this.send(false);
    }

    private void sendAsHtml() {
        this.send(true);
    }

    private void send(boolean asHtml) {
        try {
            this.message.setSentDate(this.date);
            if (asHtml) {
                this.message.setHeader("X-Mailer", "sendhtml");
                this.message.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.body, "text/html")));
            } else {
                this.message.setText(this.body);
            }
            Transport.send((Message)this.message);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public SimpleMailMessage(String smtpServer) {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpServer);
        this.sendMailSession = Session.getInstance((Properties)props, null);
        this.message = new MimeMessage(this.sendMailSession);
    }

    public void setFrom(EmailAddress from) {
        try {
            this.message.setFrom((Address)new InternetAddress(from.getAddress(), from.getName()));
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public void setReplyTo(EmailAddress from) {
        try {
            this.message.setReplyTo(new Address[]{new InternetAddress(from.getAddress(), from.getName())});
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public void addTo(EmailAddress ... to) {
        this.addAddresses(Message.RecipientType.TO, to);
    }

    public void addCc(EmailAddress ... cc) {
        this.addAddresses(Message.RecipientType.CC, cc);
    }

    public void addBcc(EmailAddress ... bcc) {
        this.addAddresses(Message.RecipientType.BCC, bcc);
    }

    public void setSubject(String in_subject) {
        try {
            this.message.setSubject(in_subject);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public void setText(String in_text) {
        this.body = in_text;
    }

    public void setSendDate(Date date) {
        this.date = date;
    }

    public void send() {
        this.sendAsHtml();
    }
}

