/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.main;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.main.MainJob;
import org.ferris.yahoo.finance.jmce.version.Version;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class Main {
    private final Logger log = Logger.getLogger(this.getClass());

    public static final void main(String[] args) {
        new Main(args);
    }

    public Main(String[] args) {
        try {
            this.init(args);
        }
        catch (Throwable t) {
            this.log.fatal((Object)t.getMessage(), t);
        }
    }

    public void init(String[] args) throws Exception {
        this.log.info((Object)"Starting:  Yahoo! Finance JMCE            ");
        this.log.info((Object)("Version: " + new Version().getVersion()));
        if (args.length == 0) {
            this.log.info((Object)"No command line arguments...scheduling.");
            this.log.info((Object)"Create Trigger");
            CronTrigger trigger = new CronTrigger("Yahoo! Finance JMCE Trigger", null, "0 30 15 ? * MON-FRI");
            this.log.info((Object)"Create Scheduler");
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.log.info((Object)"Create JobDetail");
            JobDetail jobDetail = new JobDetail(MainJob.class.getSimpleName(), null, MainJob.class);
            this.log.info((Object)"Schedule job");
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            this.log.info((Object)"Start scheduler");
            scheduler.start();
        } else {
            this.log.info((Object)("args: " + Arrays.asList(args)));
            if ("--nojmce".equals(args[0])) {
                this.log.info((Object)"--nojmce Execute immediately.");
                new MainJob().execute(null);
            } else {
                this.log.info((Object)"No command.");
                this.log.info((Object)"[DONE]");
            }
        }
    }
}

