/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.main;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.BeanFactory;
import org.ferris.yahoo.finance.jmce.bean.Dow;
import org.ferris.yahoo.finance.jmce.bean.Gold;
import org.ferris.yahoo.finance.jmce.bean.Market;
import org.ferris.yahoo.finance.jmce.bean.Message;
import org.ferris.yahoo.finance.jmce.bean.Nasdaq;
import org.ferris.yahoo.finance.jmce.bean.Oil;
import org.ferris.yahoo.finance.jmce.bean.StandardAndPoors500;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MainJob
implements Job {
    private final Logger log = Logger.getLogger(this.getClass());

    public MainJob() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("MainJob created", new Object[0]));
        }
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        try {
            this.properties();
            Market dow = this.dow();
            Market nas = this.nasdaq();
            Market sp = this.sp();
            Market gold = this.gold();
            Market oil = this.oil();
            this.saveDailyData(dow, nas, sp, gold, oil);
            this.saveYearlyData(dow, nas, sp, gold, oil);
            this.email(this.message(dow, nas, sp, gold, oil));
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    private void error(Throwable t) {
        try {
            Message message = new Message();
            message.setThrowable(t);
            BeanFactory.getMessageHandler().mailAdmin(message);
        }
        catch (Throwable ignore) {
            this.log.fatal((Object)ignore, t);
        }
    }

    private void saveDailyData(Market ... markets) {
        for (Market m : markets) {
            BeanFactory.getDayEndPriceHandler().setDayEndPriceForMarket(m.getPriceAtEndOfDay(), BeanFactory.getCalendarHandler().getNow(), m.getCode());
        }
    }

    private void saveYearlyData(Market ... markets) {
        for (Market m : markets) {
            BeanFactory.getYearEndPriceHandler().setYearEndPriceForMarket(m.getPriceAtEndOfDay(), BeanFactory.getCalendarHandler().getThisYear(), m.getCode());
        }
    }

    private void email(Message message) {
        BeanFactory.getMessageHandler().mailMessage(message);
    }

    private Message message(Market ... markets) {
        Message message = new Message();
        message.writeStart();
        message.writeHeader(BeanFactory.getCalendarHandler().getLastYear());
        for (Market m : markets) {
            message.writeMarket(m);
        }
        message.writeEnd();
        this.log.info((Object)message.toString());
        return message;
    }

    private Market dow() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("Scrape for DOW", new Object[0]));
        }
        Dow market = BeanFactory.getDowHandler().getById("http://finance.yahoo.com/q?s=^dji");
        return market;
    }

    private Market nasdaq() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("Scrape for NASDAQ", new Object[0]));
        }
        Nasdaq market = BeanFactory.getNasdaqHandler().getById("http://finance.yahoo.com/q?s=^ixic");
        return market;
    }

    private Market sp() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("Scrape for S&P", new Object[0]));
        }
        StandardAndPoors500 market = BeanFactory.getStandardAndPoors500Handler().getById("http://finance.yahoo.com/q?s=^gspc");
        return market;
    }

    private Market gold() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("Scrape for Gold", new Object[0]));
        }
        Gold market = BeanFactory.getGoldHandler().getByCurrentContract();
        return market;
    }

    private Market oil() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)String.format("Scrape for Oil", new Object[0]));
        }
        Oil market = BeanFactory.getCrudeOilHandler().getByCurrentContract();
        return market;
    }

    private void properties() {
        String resource = "/ferris-yahoo-finance-jmce-private.properties";
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(resource);
            Properties props = new Properties();
            props.load(is);
            for (String key : props.stringPropertyNames()) {
                String val = props.getProperty(key);
                System.getProperties().setProperty(key, val);
            }
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException(String.format("Problem getting resource \"%s\" as stream", resource), t);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

