/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.net;

import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.ferris.lang.string.StringTools;

public class HtmlPageContents {
    private static final Logger log = Logger.getLogger(HtmlPageContents.class);
    private String pageContentsAsHtml;

    public HtmlPageContents() {
    }

    public HtmlPageContents(String urlAsString) {
        InputStream is = null;
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("ENTER HtmlPageContents<constructor>(%s)", urlAsString));
            }
            log.info((Object)String.format("Set Default CookieManager", new Object[0]));
            CookieManager cm = new CookieManager();
            CookieHandler.setDefault(cm);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("New URL to \"%s\"", urlAsString));
            }
            URL url = new URL(urlAsString);
            if (log.isInfoEnabled()) {
                log.info((Object)"url.openStream()");
            }
            is = url.openStream();
            if (log.isInfoEnabled()) {
                log.info((Object)"Convert InputStream to String");
            }
            this.pageContentsAsHtml = IOUtils.toString((InputStream)is);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("\n----- BEGIN: PAGE CONTENTS -----\n%s\n----- END: PAGE CONTENTS -----\n", this.pageContentsAsHtml));
            }
        }
        catch (Throwable t) {
            try {
                log.fatal((Object)"Failed constructing new HtmlPageContents object", t);
                throw new RuntimeException(t);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public String getPageContentsAsHtml() {
        return this.pageContentsAsHtml;
    }

    public void setPageContentsAsHtml(String pageContentsAsHtml) {
        this.pageContentsAsHtml = pageContentsAsHtml;
    }

    private String getSnippet(String[] ids) {
        int indexOfId = 0;
        for (int i = 0; i < ids.length; ++i) {
            indexOfId = this.getPageContentsAsHtml().indexOf(ids[i], indexOfId);
            log.info((Object)String.format("Index of \"%s\" is %d", ids[i], indexOfId));
        }
        if (indexOfId < 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("IDs \"%s\" not found!", Arrays.asList(ids)));
            }
            return "";
        }
        int startIndexOfOpenTag = StringTools.indexOfBefore((String)this.getPageContentsAsHtml(), (String)"<", (int)indexOfId);
        log.info((Object)String.format("Start index of open tag \"<\" %d", startIndexOfOpenTag));
        int startIndexOfClosingTag = this.getPageContentsAsHtml().indexOf("</", indexOfId);
        log.info((Object)String.format("Start index of closing tag \"</\" %d", startIndexOfClosingTag));
        int endIndexOfClosingTag = this.getPageContentsAsHtml().indexOf(">", startIndexOfClosingTag);
        log.info((Object)String.format("End index of closing tag \"%s\" is %d", this.getPageContentsAsHtml().substring(startIndexOfClosingTag, endIndexOfClosingTag + 1), endIndexOfClosingTag));
        String span = this.getPageContentsAsHtml().substring(startIndexOfOpenTag, endIndexOfClosingTag + 1);
        log.info((Object)String.format("Returning span=\"%s\"", span));
        return span;
    }

    private String removeImg(String lineOfData) {
        int a = lineOfData.indexOf("<img");
        if (a >= 0) {
            log.info((Object)String.format("Index of <img is %d", a));
            int b = lineOfData.indexOf(">", a);
            log.info((Object)String.format("Index of > is %d", b));
            StringBuilder sp = new StringBuilder(lineOfData);
            sp = sp.replace(a, b + 1, "");
            lineOfData = sp.toString();
            log.info((Object)String.format("Now lineOfData=\"%s\"", lineOfData));
        }
        return lineOfData;
    }

    public String getContentsOfTagByIds(String ... ids) {
        String lineOfData = this.getSnippet(ids);
        lineOfData = this.removeImg(lineOfData);
        int b = lineOfData.indexOf(62, 0);
        log.info((Object)String.format("Index of > is %d", b));
        int e = lineOfData.indexOf(60, b);
        log.info((Object)String.format("Index of < is %d", e));
        String contents = lineOfData.substring(b + 1, e).trim();
        if (contents.startsWith("(")) {
            contents = contents.substring(1);
        }
        if (contents.endsWith(")")) {
            contents = contents.substring(0, contents.length() - 1);
        }
        log.info((Object)String.format("Returning contents=\"%s\"", contents));
        return contents;
    }

    public boolean contains(String whatToLookFor) {
        int idx = this.getPageContentsAsHtml().indexOf(whatToLookFor);
        return idx >= 0;
    }
}

