/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.flickrj.fascade;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.RequestContext;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.Auth;
import com.aetrion.flickr.auth.AuthInterface;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.ferris.flickrj.security.FlickrApiCredentials;
import org.xml.sax.SAXException;

class FlickrJHelper {
    private Logger log = Logger.getLogger(this.getClass());
    private FlickrApiCredentials credentials;
    private Flickr flickr;
    private RequestContext requestContext;
    private AuthInterface authInterface;
    private String frob;
    private Auth auth;

    public FlickrApiCredentials getFlickrApiCredentials() {
        return this.credentials;
    }

    FlickrJHelper(FlickrApiCredentials credentials) {
        this.log.info((Object)("CONSTRUCTOR: FlickrJHelper(" + credentials + ")"));
        this.credentials = credentials;
    }

    Flickr getFlickr() {
        if (this.flickr == null) {
            try {
                this.flickr = new Flickr(this.getFlickrApiCredentials().getApiKey(), this.getFlickrApiCredentials().getSecret(), (Transport)new REST());
                Flickr.debugStream = false;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.flickr;
    }

    RequestContext getRequestContext() {
        if (this.requestContext == null) {
            this.requestContext = RequestContext.getRequestContext();
        }
        return this.requestContext;
    }

    AuthInterface getAuthInterface() {
        if (this.authInterface == null) {
            this.authInterface = this.getFlickr().getAuthInterface();
        }
        return this.authInterface;
    }

    String getFrob() {
        if (this.frob == null) {
            try {
                this.frob = this.getAuthInterface().getFrob();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (FlickrException e) {
                throw new RuntimeException(e);
            }
            System.out.println("frob = " + this.frob);
        }
        return this.frob;
    }

    Auth getAuth() {
        if (this.auth == null) {
            try {
                this.auth = this.getFlickrApiCredentials().getAuthenticationToken() != null ? this.getAuthInterface().checkToken(this.getFlickrApiCredentials().getAuthenticationToken()) : this.getAuthInterface().getToken(this.getFrob());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (FlickrException e) {
                throw new RuntimeException(e);
            }
        }
        return this.auth;
    }
}

