/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.io;

import java.io.File;
import java.io.IOException;
import org.ferris.io.InputOutputException;
import org.ferris.io.InputOutputExceptionCode;

public class CanonicalFile {
    private File file;
    private Property[] properties;

    public static File fileInstance(File _file) {
        return new CanonicalFile(_file, Property.file, Property.exists, Property.readable, Property.writable).getFile();
    }

    public static File directoryInstance(File _file) {
        return new CanonicalFile(_file, Property.directory, Property.exists, Property.readable, Property.writable).getFile();
    }

    private CanonicalFile setFile(File _file) {
        if (_file == null) {
            throw new InputOutputException(InputOutputExceptionCode.IO000010, new Object[0]);
        }
        if (this.hasProperty(Property.exists) && !_file.exists()) {
            throw new InputOutputException(InputOutputExceptionCode.IO000011, _file);
        }
        if (this.hasProperty(Property.readable) && !_file.canRead()) {
            throw new InputOutputException(InputOutputExceptionCode.IO000012, _file);
        }
        if (this.hasProperty(Property.writable) && !_file.canWrite()) {
            throw new InputOutputException(InputOutputExceptionCode.IO000013, _file);
        }
        if (this.hasProperty(Property.directory) && !_file.isDirectory()) {
            throw new InputOutputException(InputOutputExceptionCode.IO000014, _file);
        }
        if (this.hasProperty(Property.file) && !_file.isFile()) {
            throw new InputOutputException(InputOutputExceptionCode.IO000015, _file);
        }
        try {
            this.file = _file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new InputOutputException(InputOutputExceptionCode.IO000016, (Throwable)e, e.getMessage(), _file);
        }
        return this;
    }

    private CanonicalFile setProperties(Property ... _properties) {
        this.properties = _properties;
        return this;
    }

    private Property[] getProperties() {
        return this.properties;
    }

    private boolean hasProperty(Property _property) {
        boolean found = false;
        for (int i = 0; !found && i < this.getProperties().length; ++i) {
            Property property = this.getProperties()[i];
            found = property.equals((Object)_property);
        }
        return found;
    }

    public CanonicalFile(File _file, Property ... _properties) {
        this.setProperties(_properties);
        this.setFile(_file);
    }

    public File getFile() {
        return this.file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        exists,
        readable,
        writable,
        directory,
        file;

    }
}

