/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.ferris.io.LineReader;

public class LineReaderByFile
implements LineReader {
    private File file;
    private State state;

    private File getFile() {
        return this.file;
    }

    private void setFile(File f) {
        this.file = f;
    }

    private State getState() {
        return this.state;
    }

    private void setState(State s) {
        this.state = s;
    }

    public LineReaderByFile(File file) throws IOException {
        this.setFile(file);
        this.setState(new StateIsOpen());
    }

    public int getLineNumber() {
        return this.getState().getLineNumber();
    }

    public String readLine() throws IOException {
        return this.getState().readLine();
    }

    public void close() throws IOException {
        this.getState().close();
    }

    public String toString() {
        return this.getClass().getName() + " for file: " + this.getFile();
    }

    private class StateIsClosed
    implements State {
        private StateIsClosed() {
        }

        public void close() throws IOException {
        }

        public int getLineNumber() {
            return -1;
        }

        public String readLine() throws IOException {
            return null;
        }
    }

    private class StateIsOpen
    implements State {
        private LineNumberReader reader;

        public StateIsOpen() throws IOException {
            this.reader = new LineNumberReader(new InputStreamReader(new FileInputStream(LineReaderByFile.this.getFile())));
        }

        public void close() throws IOException {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                this.reader = null;
                LineReaderByFile.this.setState(new StateIsClosed());
            }
        }

        public int getLineNumber() {
            return this.reader.getLineNumber();
        }

        public String readLine() throws IOException {
            return this.reader.readLine();
        }
    }

    private static interface State
    extends LineReader {
    }
}

