/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.ferris.io.LineWriter;

public class LineWriterByTempFile
implements LineWriter {
    private Logger log = Logger.getLogger(this.getClass());
    private File file;
    private int lineCount;
    private PrintWriter writer;

    private void setFile(String prefix, String suffix) throws IOException {
        this.file = File.createTempFile(prefix, suffix);
        this.file.deleteOnExit();
        this.log.info((Object)("Created: " + this.file));
    }

    private void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    private void setWriter() throws FileNotFoundException {
        this.writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.getFile())));
    }

    private PrintWriter getWriter() {
        if (this.writer == null) {
            throw new IllegalStateException("The writer has already been flushed and closed!");
        }
        return this.writer;
    }

    public LineWriterByTempFile(String prefix, String suffix) throws IOException {
        this.setLineCount(0);
        this.setFile(prefix, suffix);
        this.setWriter();
    }

    public void write(String data) throws IOException {
        this.getWriter().print(data);
    }

    public void writeln(String data) throws IOException {
        this.getWriter().println(data);
        this.setLineCount(this.getLineCount() + 1);
    }

    public void close() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public File getFile() {
        return this.file;
    }
}

