/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.lang.number;

import org.apache.commons.lang.StringUtils;

public class NumberTools {
    public static final String rightPad(Number number, int length, char paddingCharacter) {
        if (number == null) {
            return StringUtils.repeat((String)String.valueOf(paddingCharacter), (int)length);
        }
        return StringUtils.rightPad((String)number.toString(), (int)length, (char)paddingCharacter);
    }

    public static final String rightPadToStrictLength(Number number, int length, char paddingCharacter) {
        String s = NumberTools.rightPad(number, length, paddingCharacter);
        if (s.length() > length) {
            throw new RuntimeException("The number has a string representation of \"" + s + "\" which" + " " + "has a length of " + s.length() + " and this is longer than " + length + " " + "so I cannot right pad the character '" + paddingCharacter + "' to it");
        }
        return s;
    }

    public static final String leftPad(Number number, int length, char paddingCharacter) {
        if (number == null) {
            return StringUtils.repeat((String)String.valueOf(paddingCharacter), (int)length);
        }
        return StringUtils.leftPad((String)number.toString(), (int)length, (char)paddingCharacter);
    }

    public static final String leftPadToStrictLength(Number number, int length, char paddingCharacter) {
        String s = NumberTools.leftPad(number, length, paddingCharacter);
        if (s.length() > length) {
            throw new RuntimeException("The number has a string representation of \"" + s + "\" which" + " " + "has a length of " + s.length() + " and this is longer than " + length + " " + "so I cannot left pad the character '" + paddingCharacter + "' to it");
        }
        return s;
    }
}

