/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.lang.string;

import org.apache.commons.lang.StringUtils;

public class StringTools {
    public static int indexOfBefore(String searchMe, String findMe, int startAtMe) {
        if (startAtMe < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (startAtMe >= searchMe.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        int realStartIndex = startAtMe - findMe.length();
        int realEndIndex = startAtMe;
        while (realStartIndex >= 0) {
            String s = searchMe.substring(realStartIndex, realEndIndex);
            if (s.equals(findMe)) {
                return realStartIndex;
            }
            --realStartIndex;
            --realEndIndex;
        }
        return -1;
    }

    public static final String trimToDefault(String str, String defaultStr) {
        return (str = StringUtils.trimToNull((String)str)) == null ? defaultStr : str;
    }

    public static final String rightPadToStrictLength(String str, int length, char paddingCharacter) {
        String s = StringUtils.rightPad((String)str, (int)length, (char)paddingCharacter);
        if (s != null && s.length() > length) {
            throw new RuntimeException("The string \"" + s + "\" has a length of " + s.length() + " and this is longer than" + " " + length + " so I cannot right pad the character '" + paddingCharacter + "' to it");
        }
        return s;
    }

    public static final String leftPadToStrictLength(String str, int length, char paddingCharacter) {
        String s = StringUtils.leftPad((String)str, (int)length, (char)paddingCharacter);
        if (s != null && s.length() > length) {
            throw new RuntimeException("The string \"" + s + "\" has a length of " + s.length() + " and this is longer than" + " " + length + " so I cannot left pad the character '" + paddingCharacter + "' to it");
        }
        return s;
    }
}

