/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing;

import java.awt.Robot;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.ferris.swing.event.AppendAllEvent;
import org.ferris.swing.event.AppendListener;
import org.ferris.swing.event.AppendNextEvent;
import org.ferris.swing.ui.ThrowableDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAppendScrollPane
extends JScrollPane {
    private static final long serialVersionUID = -5198165078937900986L;
    private Logger log = Logger.getLogger(this.getClass());
    protected Set<AppendListener> appendListeners;
    protected MyAdjustmentListener myAdjustmentListener;

    public JAppendScrollPane() {
        JScrollBar bar = this.getVerticalScrollBar();
        bar.addAdjustmentListener(this.getMyAdjustmentListener());
    }

    public void addAppendListener(AppendListener listener) {
        this.getAppendListeners().add(listener);
    }

    public boolean removeAppendListener(AppendListener listener) {
        return this.getAppendListeners().remove(listener);
    }

    protected MyAdjustmentListener getMyAdjustmentListener() {
        if (this.myAdjustmentListener == null) {
            this.myAdjustmentListener = new MyAdjustmentListener();
        }
        return this.myAdjustmentListener;
    }

    protected Set<AppendListener> getAppendListeners() {
        if (this.appendListeners == null) {
            this.appendListeners = new HashSet<AppendListener>();
        }
        return this.appendListeners;
    }

    protected void fireAppendEvent() {
        this.log.info((Object)"ENTER fireAppendEvent()");
        for (AppendListener listener : this.getAppendListeners()) {
            listener.append(new AppendNextEvent());
        }
    }

    protected void fireAppendAllEvent() {
        this.log.info((Object)"fireAppendAllEvent()");
        for (AppendListener listener : this.getAppendListeners()) {
            listener.append(new AppendAllEvent());
        }
    }

    protected class MyAdjustmentListener
    implements AdjustmentListener {
        protected MyAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            JScrollBar bar = (JScrollBar)e.getAdjustable();
            JAppendScrollPane.this.log.debug((Object)("Bar isVisible: " + bar.isVisible()));
            if (bar.isVisible()) {
                int max = bar.getMaximum();
                JAppendScrollPane.this.log.debug((Object)("Bar max: " + max));
                int atEnd = bar.getValue() + bar.getVisibleAmount();
                JAppendScrollPane.this.log.debug((Object)("Bar atEnd: " + atEnd));
                if (atEnd == max) {
                    JAppendScrollPane.this.log.debug((Object)("Bar valueIsAdjusting: " + bar.getValueIsAdjusting()));
                    if (bar.getValueIsAdjusting()) {
                        try {
                            Robot r = new Robot();
                            r.mouseRelease(16);
                        }
                        catch (Exception ex) {
                            new ThrowableDialog(ex, true);
                        }
                        JAppendScrollPane.this.fireAppendAllEvent();
                    } else {
                        JAppendScrollPane.this.fireAppendEvent();
                    }
                } else {
                    JAppendScrollPane.this.log.debug((Object)"Don't fire");
                }
            } else {
                JAppendScrollPane.this.log.debug((Object)"Don't fire");
            }
        }
    }
}

