/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.aop;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.NullType;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.ff4j.FF4j;
import org.ff4j.aop.Flip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="ff.advisor")
public class FeatureAdvisor
implements MethodInterceptor,
BeanPostProcessor,
ApplicationContextAware {
    static final Logger logger = LoggerFactory.getLogger(FeatureAdvisor.class);
    private Map<String, Logger> targetLoggers = new HashMap<String, Logger>();
    private Set<String> targetInterfacesNames = new HashSet<String>();
    private ApplicationContext appCtx;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> target = bean.getClass();
        if (!target.isInterface() && target.getInterfaces() != null) {
            for (Class<?> currentInterface : target.getInterfaces()) {
                String currentInterfaceName = currentInterface.getCanonicalName();
                if (currentInterfaceName.startsWith("java.") || this.targetInterfacesNames.contains(currentInterfaceName)) continue;
                this.targetInterfacesNames.add(currentInterfaceName);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object invoke(MethodInvocation pMInvoc) throws Throwable {
        Method method = pMInvoc.getMethod();
        if (this.targetLoggers.get(method.getDeclaringClass().getCanonicalName()) == null) {
            this.targetLoggers.put(method.getDeclaringClass().getCanonicalName(), LoggerFactory.getLogger(method.getDeclaringClass()));
        }
        Logger logger = this.targetLoggers.get(method.getDeclaringClass().getCanonicalName());
        if (method.isAnnotationPresent(Flip.class)) {
            Flip ff = method.getAnnotation(Flip.class);
            boolean shouldFlip = false;
            shouldFlip = ff.strategy() != NullType.class ? (!"".equals(ff.expression()) ? FF4j.isFlipped((String)ff.name(), (Object[])new Object[]{ff.strategy().newInstance(), ff.expression()}) : FF4j.isFlipped((String)ff.name(), (Object[])new Object[]{ff.strategy().newInstance()})) : FF4j.isFlipped((String)ff.name(), (Object[])new Object[0]);
            if (shouldFlip) {
                logger.debug("FeatureFlipping on method:{} class:{}", (Object)method.getName(), (Object)method.getDeclaringClass().getName());
                if (ff.alterBean() != null && !ff.alterBean().isEmpty()) {
                    if (!this.appCtx.containsBean(ff.alterBean())) {
                        throw new BeanCreationException("ff4j-aop : bean name '" + ff.alterBean() + "' has not been found in applicationContext still declared in 'alterBean' property of bean " + method.getDeclaringClass());
                    }
                    return method.invoke(this.appCtx.getBean(ff.alterBean(), method.getDeclaringClass()), pMInvoc.getArguments());
                }
                if (ff.alterClazz() != null) {
                    return method.invoke(this.appCtx.getBean(ff.alterClazz()), pMInvoc.getArguments());
                }
                throw new IllegalArgumentException("FeatFlip: 'alterBeanName' or 'alterClazz' should be provided in " + method.getDeclaringClass());
            }
        }
        return pMInvoc.proceed();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }
}

