/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.NullType;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.ff4j.FF4j;
import org.ff4j.aop.Flip;
import org.ff4j.core.FlipStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="ff.advisor")
public class FeatureAdvisor
implements MethodInterceptor,
BeanPostProcessor,
ApplicationContextAware {
    private final Map<String, Logger> targetLoggers = new HashMap<String, Logger>();
    private final Set<String> targetInterfacesNames = new HashSet<String>();
    private final Map<String, FlipStrategy> strategySingletons = new HashMap<String, FlipStrategy>();
    private ApplicationContext appCtx;
    @Autowired
    private FF4j ff4j;

    public Object invoke(MethodInvocation pMInvoc) throws Throwable {
        Flip ff;
        Method method = pMInvoc.getMethod();
        Logger targetLogger = this.getLogger(method);
        if (method.isAnnotationPresent(Flip.class) && this.shouldFlip(ff = method.getAnnotation(Flip.class))) {
            if (!this.assertRequiredParams(ff)) {
                String msg = String.format("alterBeanName or alterClazz is required for {}", method.getDeclaringClass());
                throw new IllegalArgumentException(msg);
            }
            if (this.shouldCallAlterBeanMethod(pMInvoc, ff.alterBean(), targetLogger)) {
                return this.callAlterBeanMethod(pMInvoc, ff.alterBean(), targetLogger);
            }
            if (this.shouldCallAlterClazzMethod(pMInvoc, ff.alterClazz(), targetLogger)) {
                return this.callAlterClazzMethodOnFirst(pMInvoc, ff, targetLogger);
            }
        }
        return pMInvoc.proceed();
    }

    private boolean assertRequiredParams(Flip ff) {
        boolean alterBeanPresent = ff.alterBean() != null && !ff.alterBean().isEmpty();
        boolean alterClazPresent = ff.alterClazz() != null && ff.alterClazz() != NullType.class;
        return alterBeanPresent || alterClazPresent;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Class<?> target = bean.getClass();
        if (!target.isInterface() && target.getInterfaces() != null) {
            for (Class<?> currentInterface : target.getInterfaces()) {
                String currentInterfaceName = currentInterface.getCanonicalName();
                if (currentInterfaceName.startsWith("java.") || this.targetInterfacesNames.contains(currentInterfaceName)) continue;
                this.targetInterfacesNames.add(currentInterfaceName);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    private Logger getLogger(Method targetMethod) {
        String methodName = targetMethod.getDeclaringClass().getCanonicalName();
        if (!this.targetLoggers.containsKey(methodName)) {
            this.targetLoggers.put(methodName, LoggerFactory.getLogger(targetMethod.getDeclaringClass()));
        }
        return this.targetLoggers.get(methodName);
    }

    private boolean shouldFlip(Flip ff) {
        boolean shouldFlip = false;
        if (ff.strategy() != NullType.class) {
            String strategyClassName = ff.strategy().getCanonicalName();
            if (!this.strategySingletons.containsKey(strategyClassName)) {
                try {
                    this.strategySingletons.put(strategyClassName, (FlipStrategy)ff.strategy().newInstance());
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("ff4j-aop: Cannot instanciate alterbean " + strategyClassName + " please check default constructor existence & visibility", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("ff4j-aop: Cannot instanciate alterbean " + strategyClassName + " please check constructor visibility", e);
                }
            }
            FlipStrategy targetStrategy = this.strategySingletons.get(strategyClassName);
            shouldFlip = !"".equals(ff.expression()) ? this.getFf4j().isFlipped(ff.name(), targetStrategy, new Object[]{ff.expression()}) : this.getFf4j().isFlipped(ff.name(), targetStrategy, new Object[0]);
        } else {
            shouldFlip = this.getFf4j().isFlipped(ff.name(), new Object[0]);
        }
        return shouldFlip;
    }

    private boolean shouldCallAlterBeanMethod(MethodInvocation pMInvoc, String alterBean, Logger logger) {
        boolean callAlterBeanMethod = false;
        Method method = pMInvoc.getMethod();
        Component component = pMInvoc.getThis().getClass().getAnnotation(Component.class);
        String currentBeanName = component.value();
        if (alterBean != null && !alterBean.isEmpty()) {
            if (alterBean.equals(currentBeanName)) {
                logger.debug("FeatureFlipping on method:{} class:{} already on the alterBean {}", new Object[]{method.getName(), method.getDeclaringClass().getName(), alterBean});
            } else {
                if (!this.appCtx.containsBean(alterBean)) {
                    throw new BeanCreationException("ff4j-aop : bean name '" + alterBean + "' has not been found in applicationContext still declared in 'alterBean' property of bean " + method.getDeclaringClass());
                }
                callAlterBeanMethod = true;
            }
        }
        return callAlterBeanMethod;
    }

    private Object callAlterBeanMethod(MethodInvocation pMInvoc, String alterBean, Logger targetLogger) {
        Method method = pMInvoc.getMethod();
        targetLogger.debug("FeatureFlipping on method:{} class:{}", (Object)method.getName(), (Object)method.getDeclaringClass().getName());
        try {
            return method.invoke(this.appCtx.getBean(alterBean, method.getDeclaringClass()), pMInvoc.getArguments());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ff4j-aop: Cannot invoke method " + method.getName() + " on bean " + alterBean, e);
        }
    }

    private boolean shouldCallAlterClazzMethod(MethodInvocation pMInvoc, Class<?> alterClass, Logger logger) {
        boolean callAlterBeanMethod = false;
        Method method = pMInvoc.getMethod();
        Class<?> currentClass = pMInvoc.getThis().getClass();
        if (alterClass != null && alterClass != NullType.class) {
            boolean bl = callAlterBeanMethod = !currentClass.equals(alterClass);
            if (!callAlterBeanMethod) {
                logger.debug("FeatureFlipping on method:{} class:{} already on the alterClazz {}", new Object[]{method.getName(), method.getDeclaringClass().getName(), alterClass});
            }
        }
        return callAlterBeanMethod;
    }

    private Object callAlterClazzMethodOnFirst(MethodInvocation pMInvoc, Flip ff, Logger targetLogger) {
        Map beans = this.appCtx.getBeansOfType(pMInvoc.getMethod().getDeclaringClass());
        for (Object bean : beans.values()) {
            if (!this.isBeanAProxyOfAlterClass(bean, ff.alterClazz())) continue;
            return this.callAlterClazzMethod(pMInvoc, bean, targetLogger);
        }
        throw new BeanCreationException("ff4j-aop : bean with class '" + ff.alterClazz() + "' has not been found in applicationContext still declared in 'alterClazz' property of bean " + pMInvoc.getMethod().getDeclaringClass());
    }

    private Object callAlterClazzMethod(MethodInvocation pMInvoc, Object targetBean, Logger targetLogger) {
        Method method = pMInvoc.getMethod();
        String declaringClass = method.getDeclaringClass().getName();
        targetLogger.debug("FeatureFlipping on method:{} class:{}", (Object)method.getName(), (Object)declaringClass);
        try {
            return method.invoke(targetBean, pMInvoc.getArguments());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("ff4j-aop: Cannot invoke " + method.getName() + " on alterbean " + declaringClass + " please check visibility", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("ff4j-aop: Cannot invoke " + method.getName() + " on alterbean " + declaringClass + " please check signatures", e);
        }
    }

    protected boolean isBeanAProxyOfAlterClass(Object proxy, Class<?> alterClass) {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            try {
                return ((Advised)proxy).getTargetSource().getTarget().getClass().equals(alterClass);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("ff4j-aop: Cannot evaluate is target bean is proxy", e);
            }
        }
        return proxy.getClass().equals(alterClass);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.appCtx = applicationContext;
    }

    public FF4j getFf4j() {
        return this.ff4j;
    }
}

