/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.aop;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.ff4j.aop.FeatureAdvisor;
import org.ff4j.aop.Flip;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.stereotype.Component;

@Component(value="ff.autoproxy")
public class FeatureAutoProxy
extends AbstractAutoProxyCreator {
    private static final long serialVersionUID = -364406999854610869L;
    private final Map<String, Boolean> processedInterface = new HashMap<String, Boolean>();

    public FeatureAutoProxy() {
        this.setInterceptorNames(new String[]{FeatureAdvisor.class.getAnnotation(Component.class).value()});
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource targetSource) {
        if (!beanClass.isInterface() && beanClass.getInterfaces() != null) {
            for (Class<?> currentInterface : beanClass.getInterfaces()) {
                Object[] r = this.addAnnotedInterface(currentInterface);
                if (r == null) continue;
                return r;
            }
        }
        return DO_NOT_PROXY;
    }

    private Object[] addAnnotedInterface(Class<?> currentInterface) {
        String currentInterfaceName = currentInterface.getCanonicalName();
        if (!currentInterfaceName.startsWith("java.")) {
            Boolean isInterfaceFlipped = this.processedInterface.get(currentInterfaceName);
            if (isInterfaceFlipped != null) {
                if (isInterfaceFlipped.booleanValue()) {
                    return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
                }
            } else {
                for (Method method : currentInterface.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(Flip.class)) continue;
                    this.processedInterface.put(currentInterfaceName, true);
                    return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
                }
                this.processedInterface.put(currentInterfaceName, false);
            }
        }
        return null;
    }
}

