/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.namespace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ff4j.FF4j;
import org.ff4j.property.store.InMemoryPropertyStore;
import org.ff4j.spring.namespace.FF4jNameSpaceConstants;
import org.ff4j.store.InMemoryFeatureStore;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class FF4jBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser
implements FF4jNameSpaceConstants {
    private static Log logger = LogFactory.getLog(FF4jBeanDefinitionParser.class);

    protected Class<FF4j> getBeanClass(Element pelement) {
        return FF4j.class;
    }

    protected void postProcess(BeanDefinitionBuilder definitionBuilder, Element ff4jTag) {
        super.postProcess(definitionBuilder, ff4jTag);
        logger.debug((Object)"Initialization from <ff4j:ff4j> TAG");
        if (StringUtils.hasLength((String)ff4jTag.getAttribute("fileName"))) {
            String fileName = ff4jTag.getAttribute("fileName");
            InMemoryFeatureStore imfs = new InMemoryFeatureStore(fileName);
            InMemoryPropertyStore imps = new InMemoryPropertyStore(fileName);
            definitionBuilder.getBeanDefinition().getPropertyValues().addPropertyValue("featureStore", (Object)imfs);
            definitionBuilder.getBeanDefinition().getPropertyValues().addPropertyValue("propertiesStore", (Object)imps);
            logger.debug((Object)("... Setting in-memory stores : " + imfs.readAll().size() + " feature(s), " + imps.readAllProperties().size() + " propertie(s)"));
        }
        if (StringUtils.hasLength((String)ff4jTag.getAttribute("autocreate"))) {
            String autocreate = ff4jTag.getAttribute("autocreate");
            logger.debug((Object)("... Setting autocreate property to '" + autocreate + "'"));
        }
        if (StringUtils.hasLength((String)ff4jTag.getAttribute("authManager"))) {
            String authManagerBeanId = ff4jTag.getAttribute("authManager");
            RuntimeBeanReference refSolution = new RuntimeBeanReference(authManagerBeanId);
            definitionBuilder.getBeanDefinition().getPropertyValues().addPropertyValue("authorizationsManager", (Object)refSolution);
            logger.debug((Object)("... Setting authorizationManager with " + authManagerBeanId));
        }
        logger.debug((Object)"... Initialization done");
    }
}

