/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.placeholder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;

public class PropertiesPlaceHolderBeanDefinitionVisitor
extends BeanDefinitionVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesPlaceHolderBeanDefinitionVisitor.class);
    private Map<String, Property<?>> propertiesMap = new HashMap();
    private Map<String, Feature> featuresMap = new HashMap<String, Feature>();
    public static final String PLACEHOLDER_PROPERTY_PREFIX = "@ff4jProperty{";
    public static final String PLACEHOLDER_FEATURE_PREFIX = "@ff4jFeature{";
    public static final String PLACEHOLDER_SUFFIX = "}";

    public PropertiesPlaceHolderBeanDefinitionVisitor(FF4j ff4j) {
        if (ff4j == null) {
            throw new IllegalArgumentException("Cannot initialize placeholding 'ff4j' is null");
        }
        this.propertiesMap = ff4j.getProperties();
        this.featuresMap = ff4j.getFeatures();
    }

    protected String resolveStringValue(String strVal) throws BeansException {
        return this.parseStringValue(strVal, this.propertiesMap, this.featuresMap, new HashSet<String>());
    }

    protected String parseStringValue(String strVal, Map<String, Property<?>> propertiesMap, Map<String, Feature> featureMap, Set<String> visitedPlaceholders) throws BeanDefinitionStoreException {
        String propVal;
        String placeholder;
        int endIndex;
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(PLACEHOLDER_PROPERTY_PREFIX);
        while (startIndex != -1) {
            endIndex = buf.toString().indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PROPERTY_PREFIX.length());
            if (endIndex != -1) {
                placeholder = buf.substring(startIndex + PLACEHOLDER_PROPERTY_PREFIX.length(), endIndex);
                if (!visitedPlaceholders.add(placeholder)) {
                    throw new BeanDefinitionStoreException("Circular placeholder reference '" + placeholder + "' in property definitions");
                }
                if (propertiesMap == null || !propertiesMap.containsKey(placeholder)) {
                    throw new PropertyNotFoundException("@ff4jProperty{: Cannot perform placeholding on " + placeholder);
                }
                propVal = propertiesMap.get(placeholder).asString();
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, propertiesMap, featureMap, visitedPlaceholders);
                    buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolved placeholder '{}' to value '{}'", (Object)placeholder, (Object)propVal);
                    }
                } else {
                    throw new BeanDefinitionStoreException("Could not resolve placeholder '" + placeholder + "'");
                }
                startIndex = buf.toString().indexOf(PLACEHOLDER_PROPERTY_PREFIX, startIndex + propVal.length());
                visitedPlaceholders.remove(placeholder);
                continue;
            }
            startIndex = -1;
        }
        startIndex = strVal.indexOf(PLACEHOLDER_FEATURE_PREFIX);
        while (startIndex != -1) {
            endIndex = buf.toString().indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_FEATURE_PREFIX.length());
            if (endIndex != -1) {
                placeholder = buf.substring(startIndex + PLACEHOLDER_FEATURE_PREFIX.length(), endIndex);
                if (!visitedPlaceholders.add(placeholder)) {
                    throw new BeanDefinitionStoreException("Circular placeholder reference '" + placeholder + "' in property definitions");
                }
                if (featureMap == null || !featureMap.containsKey(placeholder)) {
                    throw new FeatureNotFoundException("@ff4jFeature{: Cannot perform placeholding on " + placeholder);
                }
                propVal = String.valueOf(featureMap.get(placeholder).isEnable());
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, propertiesMap, featureMap, visitedPlaceholders);
                    buf.replace(startIndex, endIndex + PLACEHOLDER_FEATURE_PREFIX.length(), propVal);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolved placeholder '{}' to value '{}'", (Object)placeholder, (Object)propVal);
                    }
                } else {
                    throw new BeanDefinitionStoreException("Could not resolve placeholder '" + placeholder + "'");
                }
                startIndex = buf.toString().indexOf(PLACEHOLDER_FEATURE_PREFIX, startIndex + propVal.length());
                visitedPlaceholders.remove(placeholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

