/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.autowire;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.spring.autowire.FF4JFeature;
import org.ff4j.spring.autowire.FF4JProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Component(value="ff4j.autowiringpostprocessor")
public class AutowiredFF4JBeanPostProcessor
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private FF4j ff4j;

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        Class<?> beanClass = bean.getClass();
        for (Field field : fields = this.getAllFields(beanClass)) {
            if (field.isAnnotationPresent(FF4JProperty.class)) {
                this.autoWiredProperty(bean, field);
                continue;
            }
            if (!field.isAnnotationPresent(FF4JFeature.class)) continue;
            this.autoWiredFeature(bean, field);
        }
        return bean;
    }

    private Field[] getAllFields(Class<?> beanClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = beanClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private void autoWiredFeature(Object bean, Field field) {
        Feature feature;
        FF4JFeature annFeature = field.getAnnotation(FF4JFeature.class);
        String annValue = annFeature.value();
        String featureName = field.getName();
        if (annValue != null && !"".equals(annValue)) {
            featureName = annValue;
        }
        if ((feature = this.readFeature(field, featureName, annFeature.required())) != null) {
            if (Feature.class.isAssignableFrom(field.getType())) {
                this.injectValue(field, bean, featureName, feature);
            } else if (Boolean.class.isAssignableFrom(field.getType())) {
                this.injectValue(field, bean, featureName, feature.isEnable());
            } else if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                this.injectValue(field, bean, featureName, feature.isEnable());
            } else {
                throw new IllegalArgumentException("Field annotated with @FF4JFeature must inherit from org.ff4j.Feature or be boolean " + field.getType() + " [class=" + bean.getClass().getName() + ", field=" + field.getName() + "]");
            }
        }
    }

    private void autoWiredProperty(Object bean, Field field) {
        FF4JProperty annProperty = field.getAnnotation(FF4JProperty.class);
        String propertyName = StringUtils.hasLength((String)annProperty.value()) ? annProperty.value() : field.getName();
        Property<?> property = this.readProperty(field, propertyName, annProperty.required());
        if (property != null) {
            if (Property.class.isAssignableFrom(field.getType())) {
                this.injectValue(field, bean, propertyName, property);
            } else if (property.parameterizedType().isAssignableFrom(field.getType())) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Integer.class) && field.getType().equals(Integer.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Long.class) && field.getType().equals(Long.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Double.class) && field.getType().equals(Double.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Byte.class) && field.getType().equals(Byte.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Boolean.class) && field.getType().equals(Boolean.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Short.class) && field.getType().equals(Short.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Character.class) && field.getType().equals(Character.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else if (property.parameterizedType().equals(Float.class) && field.getType().equals(Float.TYPE) && null != property.getValue()) {
                this.injectValue(field, bean, propertyName, property.getValue());
            } else {
                throw new IllegalArgumentException("Field annotated with @FF4JProperty must inherit from org.ff4j.property.AbstractProperty or be of type " + property.parameterizedType() + "but is " + field.getType() + " [class=" + bean.getClass().getName() + ", field=" + field.getName() + "]");
            }
        }
    }

    private void injectValue(Field field, Object currentBean, String propName, Object propValue) {
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)currentBean, (Object)propValue);
        this.logger.debug((Object)("Injection of property '" + propName + "' on " + currentBean.getClass().getName() + "." + field.getName()));
    }

    private Feature readFeature(Field field, String featureName, boolean required) {
        if (!this.ff4j.getFeatureStore().exist(featureName)) {
            if (required) {
                throw new IllegalArgumentException("Cannot autowiring field '" + field.getName() + "' with FF4J property as target feature has not been found");
            }
            this.logger.warn((Object)("Feature '" + featureName + "' has not been found but not required"));
            return null;
        }
        return this.ff4j.getFeatureStore().read(featureName);
    }

    private Property<?> readProperty(Field field, String propertyName, boolean required) {
        if (!this.ff4j.getPropertiesStore().existProperty(propertyName)) {
            if (required) {
                throw new IllegalArgumentException("Cannot autowiring field '" + field.getName() + "' with FF4J property as target property has not been found");
            }
            this.logger.warn((Object)("Property '" + propertyName + "' has not been found but not required"));
            return null;
        }
        return this.ff4j.getPropertiesStore().readProperty(propertyName);
    }
}

