/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureCacheProviderEhCache
implements FF4JCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(FF4jCacheProxy.class);
    private Configuration cacheConfiguration;
    private CacheManager cacheManager;
    private Cache cacheFeatures = null;
    private Cache cacheProperties = null;

    public FeatureCacheProviderEhCache() {
    }

    public FeatureCacheProviderEhCache(Configuration config) {
        this.cacheConfiguration = config;
    }

    public String getCacheProviderName() {
        return "EHCACHE";
    }

    public Set<String> listCachedFeatureNames() {
        return new HashSet<String>(this.getCacheFeatures().getKeys());
    }

    private synchronized void initializeCache() {
        if (this.cacheManager == null) {
            this.cacheManager = this.cacheConfiguration == null ? CacheManager.create() : CacheManager.create((Configuration)this.cacheConfiguration);
        }
        this.cacheManager.addCacheIfAbsent("ff4jCacheFeatures");
        this.cacheManager.addCacheIfAbsent("ff4jCacheProperties");
        this.cacheFeatures = this.cacheManager.getCache("ff4jCacheFeatures");
        this.cacheProperties = this.cacheManager.getCache("ff4jCacheProperties");
        LOG.debug("CacheManager initialized as '{}'", (Object)this.cacheFeatures.getName());
    }

    public void clearFeatures() {
        this.getCacheFeatures().flush();
    }

    public void clearProperties() {
        this.getCacheProperties().flush();
    }

    public void evictFeature(String featureId) {
        this.getCacheFeatures().remove((Serializable)((Object)featureId));
    }

    public void evictProperty(String propertyName) {
        this.getCacheProperties().remove((Serializable)((Object)propertyName));
    }

    public void putFeature(Feature feat) {
        this.getCacheFeatures().put(new Element((Serializable)((Object)feat.getUid()), (Serializable)feat));
    }

    public void putProperty(Property<?> property) {
        this.getCacheProperties().put(new Element((Serializable)((Object)property.getName()), property));
    }

    public Feature getFeature(String featureId) {
        Element e = this.getCacheFeatures().get((Serializable)((Object)featureId));
        if (e != null) {
            return (Feature)e.getObjectValue();
        }
        return null;
    }

    public Property<?> getProperty(String featureId) {
        Element e = this.getCacheProperties().get((Serializable)((Object)featureId));
        if (e != null) {
            return (Property)e.getObjectValue();
        }
        return null;
    }

    public Set<String> listCachedPropertyNames() {
        return new HashSet<String>(this.getCacheProperties().getKeys());
    }

    public Object getFeatureNativeCache() {
        return this.getCacheFeatures();
    }

    public Object getPropertyNativeCache() {
        return this.getCacheProperties();
    }

    public Cache getCacheFeatures() {
        if (this.cacheFeatures == null) {
            this.initializeCache();
        }
        return this.cacheFeatures;
    }

    public void setCacheFeatures(Cache cacheFeatures) {
        this.cacheFeatures = cacheFeatures;
    }

    public Cache getCacheProperties() {
        if (this.cacheProperties == null) {
            this.initializeCache();
        }
        return this.cacheProperties;
    }

    public void setCacheProperties(Cache cacheProperties) {
        this.cacheProperties = cacheProperties;
    }

    public Configuration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public void setCacheConfiguration(Configuration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

