/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import org.ff4j.ehcache.FF4jEhCacheWrapper;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;

public class PropertyStoreEhCache
extends AbstractPropertyStore {
    private FF4jEhCacheWrapper wrapper;

    public PropertyStoreEhCache() {
        this.wrapper = new FF4jEhCacheWrapper();
    }

    public PropertyStoreEhCache(Configuration cacheConfig) {
        this.wrapper = new FF4jEhCacheWrapper(cacheConfig);
    }

    public PropertyStoreEhCache(String xmlEhCacheConfig) {
        this.wrapper = new FF4jEhCacheWrapper(xmlEhCacheConfig);
    }

    public boolean existProperty(String name) {
        Util.assertParamHasLength((String)name, (String)"Property name");
        return this.wrapper.getCacheProperties().get((Serializable)((Object)name)) != null;
    }

    public <T> void createProperty(Property<T> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
        if (this.existProperty(property.getName())) {
            throw new PropertyAlreadyExistException(property.getName());
        }
        this.wrapper.getCacheProperties().put(new Element((Serializable)((Object)property.getName()), property));
    }

    public Property<?> readProperty(String name) {
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        return (Property)this.wrapper.getCacheProperties().get((Serializable)((Object)name)).getObjectValue();
    }

    public void updateProperty(String name, String newValue) {
        Property<?> fp = this.readProperty(name);
        fp.setValueFromString(newValue);
        this.updateProperty(fp);
    }

    public <T> void updateProperty(Property<T> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (!this.existProperty(property.getName())) {
            throw new PropertyNotFoundException(property.getName());
        }
        this.wrapper.getCacheProperties().put(new Element((Serializable)((Object)property.getName()), property));
    }

    public void deleteProperty(String name) {
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.wrapper.getCacheProperties().remove((Serializable)((Object)name));
    }

    public Map<String, Property<?>> readAllProperties() {
        HashMap myMap = new HashMap();
        if (this.wrapper.getCacheProperties().getKeys() != null) {
            for (Object key : this.wrapper.getCacheProperties().getKeys()) {
                Element element = this.wrapper.getCacheProperties().get(key);
                if (element == null) continue;
                Property p = (Property)this.wrapper.getCacheProperties().get(key).getObjectValue();
                myMap.put((String)key, p);
            }
        }
        return myMap;
    }

    public Set<String> listPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Object key : this.wrapper.getCacheProperties().getKeys()) {
            propertyNames.add((String)key);
        }
        return propertyNames;
    }

    public void clear() {
        this.wrapper.getCacheProperties().removeAll();
    }
}

