/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import java.util.HashSet;
import java.util.Set;
import javax.cache.Cache;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.cache.FF4jJCacheProvider;
import org.ff4j.core.Feature;
import org.ff4j.property.AbstractProperty;

public class FF4jJCacheManager
extends FF4jJCacheProvider
implements FF4JCacheManager {
    protected static final String CACHENAME_FEATURES = "ff4jFeatures";
    protected static final String CACHENAME_PROPERTIES = "ff4jProperties";
    protected Cache<String, Feature> featuresCache = this.createCacheForFeatures();
    protected Cache<String, AbstractProperty> propertiesCache = this.createCacheForProperties();

    public FF4jJCacheManager() {
    }

    public FF4jJCacheManager(String cachingProviderClassName) {
        super(cachingProviderClassName);
    }

    protected Cache<String, Feature> createCacheForFeatures() {
        if (null == this.getCacheManager()) {
            throw new IllegalArgumentException("Cannot initialize Cache without the Cache manager");
        }
        if (null == this.getCacheManager().getCache(CACHENAME_FEATURES, String.class, Feature.class)) {
            this.getCacheManager().createCache(CACHENAME_FEATURES, this.getFeatureCacheConfiguration());
        }
        return this.getCacheManager().getCache(CACHENAME_FEATURES, String.class, Feature.class);
    }

    protected Cache<String, AbstractProperty> createCacheForProperties() {
        if (null == this.getCacheManager()) {
            throw new IllegalArgumentException("Cannot initialize Cache without the Cache manager");
        }
        if (null == this.getCacheManager().getCache(CACHENAME_PROPERTIES, String.class, AbstractProperty.class)) {
            this.getCacheManager().createCache(CACHENAME_PROPERTIES, this.getPropertyCacheConfiguration());
        }
        return this.getCacheManager().getCache(CACHENAME_PROPERTIES, String.class, AbstractProperty.class);
    }

    public Set<String> listCachedFeatureNames() {
        HashSet<String> keys = new HashSet<String>();
        this.getFeaturesCache().forEach(e -> keys.add((String)e.getKey()));
        return keys;
    }

    public Object getNativeCache() {
        if (this.featuresCache == null) {
            throw new IllegalStateException("Cache has not been initialized, please check");
        }
        return this.featuresCache;
    }

    public String getCacheProviderName() {
        if (this.featuresCache == null) {
            return null;
        }
        return "jCache:" + this.featuresCache.getName() + ":" + this.featuresCache.getCacheManager().getCachingProvider().toString();
    }

    public void clearFeatures() {
        this.getFeaturesCache().clear();
    }

    public void clearProperties() {
        this.getPropertiesCache().clear();
    }

    public void evictFeature(String featureId) {
        if (this.getFeaturesCache().containsKey((Object)featureId)) {
            this.getFeaturesCache().remove((Object)featureId);
        }
    }

    public void evictProperty(String propertyName) {
        if (this.getPropertiesCache().containsKey((Object)propertyName)) {
            this.getPropertiesCache().remove((Object)propertyName);
        }
    }

    public void putFeature(Feature feat) {
        this.getFeaturesCache().put((Object)feat.getUid(), (Object)feat);
    }

    public void putProperty(AbstractProperty<?> feat) {
        this.getPropertiesCache().put((Object)feat.getName(), feat);
    }

    public Feature getFeature(String featureId) {
        return (Feature)this.getFeaturesCache().get((Object)featureId);
    }

    public AbstractProperty<?> getProperty(String name) {
        return (AbstractProperty)this.getPropertiesCache().get((Object)name);
    }

    public Set<String> listCachedPropertyNames() {
        HashSet<String> keys = new HashSet<String>();
        this.getPropertiesCache().forEach(e -> keys.add((String)e.getKey()));
        return keys;
    }

    public Object getFeatureNativeCache() {
        return this.getFeaturesCache();
    }

    public Object getPropertyNativeCache() {
        return this.getPropertiesCache();
    }

    public Cache<String, Feature> getFeaturesCache() {
        return this.featuresCache;
    }

    public void setFeaturesCache(Cache<String, Feature> featuresCache) {
        this.featuresCache = featuresCache;
    }

    public Cache<String, AbstractProperty> getPropertiesCache() {
        return this.propertiesCache;
    }
}

