/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.ff4j.core.Feature;
import org.ff4j.property.AbstractProperty;

public class FF4jJCacheProvider {
    private CachingProvider cachingProvider;
    private CacheManager cacheManager;

    protected FF4jJCacheProvider() {
        this(null);
    }

    protected FF4jJCacheProvider(String providerClassName) {
        this.cachingProvider = this.initCachingProvider(providerClassName);
        this.cacheManager = this.initCacheManager();
    }

    protected CachingProvider initCachingProvider(String cachingProviderClassname) {
        try {
            if (cachingProviderClassname == null) {
                return Caching.getCachingProvider();
            }
            return Caching.getCachingProvider((String)cachingProviderClassname);
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    protected CacheManager initCacheManager() {
        if (this.cachingProvider == null) {
            throw new IllegalArgumentException("Cannot initialize cacheManager as CachingProvider is empty, please check 'initCachingProvider'");
        }
        return this.cachingProvider.getCacheManager();
    }

    protected MutableConfiguration<String, Feature> getFeatureCacheConfiguration() {
        MutableConfiguration featuresCacheConfig = new MutableConfiguration();
        featuresCacheConfig.setTypes(String.class, Feature.class);
        featuresCacheConfig.setStoreByValue(true);
        featuresCacheConfig.setStatisticsEnabled(false);
        return featuresCacheConfig;
    }

    protected MutableConfiguration<String, AbstractProperty> getPropertyCacheConfiguration() {
        MutableConfiguration propertiesCacheConfig = new MutableConfiguration();
        propertiesCacheConfig.setTypes(String.class, AbstractProperty.class);
        propertiesCacheConfig.setStoreByValue(true);
        propertiesCacheConfig.setStatisticsEnabled(false);
        return propertiesCacheConfig;
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

