/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.cache.FF4jJCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;

public class FeatureStoreJCache
extends AbstractFeatureStore {
    private FF4jJCacheManager cacheManager;

    public FeatureStoreJCache() {
        this.cacheManager = new FF4jJCacheManager();
    }

    public FeatureStoreJCache(String cachingProviderClassName) {
        this.cacheManager = new FF4jJCacheManager(cachingProviderClassName);
    }

    public FeatureStoreJCache(FF4jJCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean exist(String uid) {
        Util.assertParamNotNull((String)uid, (String)"Feature identifier");
        return this.getCacheManager().getFeature(uid) != null;
    }

    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        return this.getCacheManager().getFeature(uid);
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null");
        }
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        this.getCacheManager().putFeature(fp);
    }

    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.getCacheManager().putFeature(fp);
    }

    public Map<String, Feature> readAll() {
        HashMap<String, Feature> myMap = new HashMap<String, Feature>();
        this.getCacheManager().getFeaturesCache().forEach(e -> {
            Feature cfr_ignored_0 = (Feature)myMap.put((String)e.getKey(), (Feature)e.getValue());
        });
        return myMap;
    }

    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        this.getCacheManager().evictFeature(fpId);
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamNotNull((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamNotNull((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (String uid : features.keySet()) {
            if (!groupName.equals(features.get(uid).getGroup())) continue;
            group.put(uid, features.get(uid));
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    public boolean existGroup(String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (String uid : features.keySet()) {
            if (!groupName.equals(features.get(uid).getGroup())) continue;
            group.put(uid, features.get(uid));
        }
        return !group.isEmpty();
    }

    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (String uid : features.keySet()) {
            features.get(uid).enable();
            this.update(features.get(uid));
        }
    }

    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (String uid : features.keySet()) {
            features.get(uid).disable();
            this.update(features.get(uid));
        }
    }

    public void addToGroup(String featureId, String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamNotNull((String)groupName, (String)"groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (String uid : features.keySet()) {
            groups.add(features.get(uid).getGroup());
        }
        groups.remove(null);
        return groups;
    }

    public boolean isCached() {
        return true;
    }

    public String getCacheProvider() {
        return this.getCacheManager().getCacheProviderName();
    }

    public String getCachedTargetStore() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public FF4jJCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(FF4jJCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

