/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.HashMap;
import java.util.Map;
import org.ff4j.cache.FF4jJCacheManager;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;

public class PropertyStoreJCache
extends AbstractPropertyStore {
    private FF4jJCacheManager cacheManager;

    public PropertyStoreJCache() {
        this.cacheManager = new FF4jJCacheManager();
    }

    public PropertyStoreJCache(String cachingProviderClassName) {
        this.cacheManager = new FF4jJCacheManager(cachingProviderClassName);
    }

    public PropertyStoreJCache(FF4jJCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean existProperty(String name) {
        Util.assertParamNotNull((String)name, (String)"Property name");
        return this.getCacheManager().getProperty(name) != null;
    }

    public <T> void createProperty(AbstractProperty<T> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
        if (this.existProperty(property.getName())) {
            throw new PropertyAlreadyExistException(property.getName());
        }
        this.getCacheManager().putProperty(property);
    }

    public AbstractProperty<?> readProperty(String name) {
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        return this.getCacheManager().getProperty(name);
    }

    public void updateProperty(String name, String newValue) {
        AbstractProperty<?> fp = this.readProperty(name);
        fp.setValueFromString(newValue);
        this.updateProperty(fp);
    }

    public <T> void updateProperty(AbstractProperty<T> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (!this.existProperty(property.getName())) {
            throw new PropertyNotFoundException(property.getName());
        }
        this.getCacheManager().putProperty(property);
    }

    public void deleteProperty(String name) {
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.getCacheManager().evictProperty(name);
    }

    public Map<String, AbstractProperty<?>> readAllProperties() {
        HashMap myMap = new HashMap();
        this.getCacheManager().getPropertiesCache().forEach(e -> {
            AbstractProperty cfr_ignored_0 = (AbstractProperty)myMap.put((String)e.getKey(), (AbstractProperty<?>)e.getValue());
        });
        return myMap;
    }

    public FF4jJCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(FF4jJCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

