/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.test.audit;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ff4j.FF4j;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventPublisher;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.BarChart;
import org.ff4j.audit.chart.Serie;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.store.InMemoryPropertyStore;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.store.InMemoryFeatureStore;
import org.ff4j.utils.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class EventRepositoryTestSupport {
    protected FF4j ff4j = null;
    protected ArrayList<Feature> features;
    protected EventRepository repo;
    protected EventPublisher publisher;

    @Before
    public void setUp() throws Exception {
        this.ff4j = new FF4j();
        this.ff4j.setFeatureStore((FeatureStore)new InMemoryFeatureStore("test-ff4j-features.xml"));
        this.ff4j.setPropertiesStore((PropertyStore)new InMemoryPropertyStore("test-ff4j-features.xml"));
        this.ff4j.setEventRepository(this.initRepository());
        this.repo = this.ff4j.getEventRepository();
    }

    protected Event generateFeatureUsageEvent(String uid) {
        return new Event("JAVA_API", "feature", uid, "checkOn");
    }

    protected Event generateFeatureUsageEvent(String uid, long timestamp) {
        Event event = this.generateFeatureUsageEvent(uid);
        event.setTimestamp(timestamp);
        return event;
    }

    protected Event generateRandomFeatureUsageEvent(String uid, long from, long to) {
        return this.generateFeatureUsageEvent(uid, from + (long)(Math.random() * (double)(to - from)));
    }

    protected Event generateRandomFeatureUsageEvent(long from, long to) {
        return this.generateRandomFeatureUsageEvent(((Feature)Util.getRandomElement(this.features)).getUid(), from, to);
    }

    protected void populateRepository(long from, long to, int totalEvent) throws InterruptedException {
        for (int i = 0; i < totalEvent; ++i) {
            this.repo.saveEvent(this.generateRandomFeatureUsageEvent(from, to));
        }
    }

    protected abstract EventRepository initRepository();

    @Test
    public void testSaveEventUnit() throws InterruptedException {
        long start = System.currentTimeMillis();
        EventQueryDefinition eqd = new EventQueryDefinition(start, System.currentTimeMillis());
        Assert.assertEquals((long)0L, (long)this.repo.getFeatureUsageTotalHitCount(eqd));
        this.repo.saveEvent(this.generateFeatureUsageEvent("f1"));
        Thread.sleep(100L);
        EventQueryDefinition eqd2 = new EventQueryDefinition(start - 20L, System.currentTimeMillis());
        Assert.assertEquals((long)1L, (long)this.repo.getFeatureUsageTotalHitCount(eqd2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSaveEventNull() {
        Assert.assertFalse((boolean)this.repo.saveEvent(null));
    }

    @Test
    public void testSaveAuditTrail() throws InterruptedException {
        long start = System.currentTimeMillis();
        Event evt1 = new Event("JAVA_API", "feature", "f1", "create");
        this.repo.saveEvent(evt1);
        Thread.sleep(200L);
        EventQueryDefinition eqd2 = new EventQueryDefinition(start - 200L, System.currentTimeMillis());
        Assert.assertEquals((long)1L, (long)this.repo.getAuditTrail(eqd2).size());
    }

    @Test
    public void testFeatureUsageBarCharts() throws InterruptedException {
        long start = System.currentTimeMillis();
        this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "create"));
        for (int i = 0; i < 8; ++i) {
            Thread.sleep(100L);
            this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "checkOn"));
            this.repo.saveEvent(new Event("EMBEDDED_SERVLET", "feature", "f2", "checkOn"));
        }
        EventQueryDefinition testQuery = new EventQueryDefinition(start - 10L, System.currentTimeMillis() + 10L);
        BarChart bChart = this.repo.getFeatureUsageBarChart(testQuery);
        Assert.assertEquals((long)2L, (long)bChart.getChartBars().size());
        Assert.assertEquals((Object)new Integer(8), (Object)((Serie)bChart.getChartBars().get(0)).getValue());
        Assert.assertEquals((Object)new Integer(8), (Object)((Serie)bChart.getChartBars().get(1)).getValue());
        Assert.assertNotNull((Object)((Serie)bChart.getChartBars().get(0)).getColor());
        Assert.assertNotNull((Object)((Serie)bChart.getChartBars().get(1)).getColor());
    }

    @Test
    public void testFeatureUsageHitCount() throws InterruptedException {
        long start = System.currentTimeMillis();
        this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "create"));
        for (int i = 0; i < 8; ++i) {
            Thread.sleep(100L);
            this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "checkOn"));
            this.repo.saveEvent(new Event("EMBEDDED_SERVLET", "feature", "f2", "checkOn"));
        }
        Thread.sleep(100L);
        EventQueryDefinition testQuery = new EventQueryDefinition(start, System.currentTimeMillis());
        Map mapOfHit = this.repo.getFeatureUsageHitCount(testQuery);
        Assert.assertEquals((long)2L, (long)mapOfHit.size());
        Assert.assertTrue((boolean)mapOfHit.containsKey("f1"));
        Assert.assertTrue((boolean)mapOfHit.containsKey("f2"));
        Assert.assertEquals((long)8L, (long)((MutableHitCount)mapOfHit.get("f1")).get());
    }

    @Test
    public void testSearchFeatureUsageEvents() throws InterruptedException {
        long start = System.currentTimeMillis();
        this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "create"));
        for (int i = 0; i < 8; ++i) {
            Thread.sleep(100L);
            this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "checkOn"));
            this.repo.saveEvent(new Event("EMBEDDED_SERVLET", "feature", "f2", "checkOn"));
        }
        Thread.sleep(100L);
        EventQueryDefinition testQuery = new EventQueryDefinition(start - 20L, System.currentTimeMillis());
        EventSeries es = this.repo.searchFeatureUsageEvents(testQuery);
        Assert.assertEquals((long)16L, (long)es.size());
    }

    @Test
    public void testGetFeatureUsageHistory() throws InterruptedException {
        long start = System.currentTimeMillis();
        this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "create"));
        for (int i = 0; i < 8; ++i) {
            Thread.sleep(100L);
            this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "checkOn"));
            this.repo.saveEvent(new Event("EMBEDDED_SERVLET", "feature", "f2", "checkOn"));
        }
        Thread.sleep(100L);
        EventQueryDefinition testQuery = new EventQueryDefinition(start - 20L, System.currentTimeMillis());
        TimeSeriesChart tsc = this.repo.getFeatureUsageHistory(testQuery, TimeUnit.HOURS);
        Assert.assertEquals((long)1L, (long)tsc.getTimeSlots().size());
    }

    @Test
    public void testSourceHitCount() throws InterruptedException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            Thread.sleep(100L);
            this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "checkOn"));
            this.repo.saveEvent(new Event("EMBEDDED_SERVLET", "feature", "f2", "checkOn"));
        }
        Thread.sleep(200L);
        this.repo.saveEvent(new Event("WEB_API", "feature", "f1", "checkOn"));
        Thread.sleep(200L);
        EventQueryDefinition testQuery = new EventQueryDefinition(start - 20L, System.currentTimeMillis());
        Map mapOfHit = this.repo.getSourceHitCount(testQuery);
        Assert.assertEquals((long)3L, (long)mapOfHit.size());
        Assert.assertTrue((boolean)mapOfHit.containsKey("JAVA_API"));
        Assert.assertTrue((boolean)mapOfHit.containsKey("EMBEDDED_SERVLET"));
        Assert.assertEquals((long)1L, (long)((MutableHitCount)mapOfHit.get("WEB_API")).get());
    }

    @Test
    public void testUserHitCount() throws InterruptedException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            Event e1 = new Event("JAVA_API", "feature", "f1", "checkOn");
            e1.setUser("JOHN");
            this.repo.saveEvent(e1);
            Thread.sleep(100L);
            Event e2 = new Event("JAVA_API", "feature", "f1", "checkOn");
            e2.setUser("BOB");
            this.repo.saveEvent(e2);
            Thread.sleep(100L);
        }
        Thread.sleep(200L);
        EventQueryDefinition testQuery = new EventQueryDefinition(start - 20L, System.currentTimeMillis());
        Map mapOfHit = this.repo.getUserHitCount(testQuery);
        Assert.assertEquals((long)2L, (long)mapOfHit.size());
        Assert.assertTrue((boolean)mapOfHit.containsKey("JOHN"));
        Assert.assertTrue((boolean)mapOfHit.containsKey("BOB"));
        Assert.assertEquals((long)8L, (long)((MutableHitCount)mapOfHit.get("BOB")).get());
    }

    @Test
    public void testHostHitCount() throws InterruptedException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            Thread.sleep(100L);
            this.repo.saveEvent(new Event("JAVA_API", "feature", "f1", "checkOn"));
        }
        Thread.sleep(200L);
        EventQueryDefinition testQuery = new EventQueryDefinition(start, System.currentTimeMillis());
        Map mapOfHit = this.repo.getHostHitCount(testQuery);
        Assert.assertEquals((long)1L, (long)mapOfHit.size());
        Assert.assertEquals((long)1L, (long)mapOfHit.values().size());
    }

    @Test
    public void testSaveCheckOff() throws InterruptedException {
        long start = System.currentTimeMillis();
        Event evt1 = new Event("JAVA_API", "feature", "f1", "checkOff");
        Assert.assertTrue((boolean)this.repo.saveEvent(evt1));
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.repo.getFeatureUsageTotalHitCount(new EventQueryDefinition(start, System.currentTimeMillis())));
        Assert.assertEquals((long)0L, (long)this.repo.getAuditTrail(new EventQueryDefinition(start, System.currentTimeMillis())).size());
    }

    @Test
    public void testLimitEventSeries() throws InterruptedException {
        EventSeries es = new EventSeries(5L);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(10L);
            es.add(new Event("JAVA_API", "feature", "f1", "create"));
        }
        Assert.assertEquals((long)5L, (long)es.size());
    }

    @Test
    public void testGetEventByUID() throws InterruptedException {
        String dummyId = "1234-5678-9012-3456";
        Event evt1 = new Event("JAVA_API", "feature", "f1", "checkOff");
        evt1.setUuid(dummyId);
        this.repo.saveEvent(evt1);
        Thread.sleep(100L);
        Event evt = this.repo.getEventByUUID(dummyId, Long.valueOf(System.currentTimeMillis()));
        Assert.assertNotNull((Object)evt);
    }

    @Test
    public void testPurgeEvents() throws InterruptedException {
        long topStart = System.currentTimeMillis();
        Event evtAudit = new Event("JAVA_API", "feature", "f1", "create");
        evtAudit.setUuid("1234-5678-9012-3456");
        this.repo.saveEvent(evtAudit);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)this.repo.getEventByUUID(evtAudit.getUuid(), Long.valueOf(System.currentTimeMillis())));
        EventQueryDefinition testQuery = new EventQueryDefinition(topStart - 100L, System.currentTimeMillis());
        this.repo.purgeAuditTrail(testQuery);
        Thread.sleep(300L);
        Assert.assertNull((Object)this.repo.getEventByUUID(evtAudit.getUuid(), Long.valueOf(System.currentTimeMillis())));
        Event evtFeatureUsage = new Event("JAVA_API", "feature", "f2", "checkOn");
        evtFeatureUsage.setUuid("1234-5678-9012-3457");
        this.repo.saveEvent(evtFeatureUsage);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)this.repo.getEventByUUID(evtFeatureUsage.getUuid(), Long.valueOf(System.currentTimeMillis())));
        EventQueryDefinition testQuery2 = new EventQueryDefinition(topStart - 100L, System.currentTimeMillis());
        this.repo.purgeFeatureUsage(testQuery2);
        Thread.sleep(300L);
        Assert.assertNull((Object)this.repo.getEventByUUID(evtFeatureUsage.getUuid(), Long.valueOf(System.currentTimeMillis())));
    }
}

