/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.test.store;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyInt;
import org.ff4j.property.PropertyString;
import org.ff4j.store.InMemoryFeatureStore;
import org.ff4j.strategy.PonderationStrategy;
import org.ff4j.test.AssertFf4j;
import org.ff4j.utils.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FeatureStoreTestSupport {
    public static final String GOLOGOLO = "GOLOGOLO";
    public static final String ROLE_XYZ = "ROLE_XYZ";
    public static final String PPSTRING = "ppstring";
    public static final String DIGIT_VALUE = "digitValue";
    public static final String REGION_IDENTIFIER = "regionIdentifier";
    protected FF4j ff4j = null;
    protected FeatureStore testedStore;
    protected AssertFf4j assertFf4j;
    protected FeatureStore defaultStore = new InMemoryFeatureStore("test-ff4j-features.xml");

    @Before
    public void setUp() throws Exception {
        this.ff4j = new FF4j();
        this.ff4j.setFeatureStore(this.initStore());
        this.testedStore = this.ff4j.getFeatureStore();
        this.assertFf4j = new AssertFf4j(this.ff4j);
        this.assertFf4j.setPause(this.enablePause());
    }

    protected abstract FeatureStore initStore();

    protected int enablePause() {
        return 0;
    }

    @Test
    public void testStoreHasBeenInitialized() {
        this.assertFf4j.assertThatStoreHasSize(5);
        this.assertFf4j.assertThatFeatureFlipped("first");
    }

    @Test
    public void testReadAllFeatures() {
        this.assertFf4j.assertThatFeatureExist("forth");
        this.assertFf4j.assertThatStoreHasSize(5);
        Map features = this.testedStore.readAll();
        Assert.assertEquals((long)5L, (long)features.size());
        Feature f = (Feature)features.get("forth");
        Assert.assertEquals((String)"forth does not exist", (Object)f.getUid(), (Object)"forth");
        Assert.assertTrue((String)"no description", (f.getDescription() != null && !"".equals(f.getDescription()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"no authorizations", (f.getPermissions() != null && !f.getPermissions().isEmpty() ? 1 : 0) != 0);
        this.assertFf4j.assertThatFeatureHasRole("forth", "ADMINISTRATOR");
        this.assertFf4j.assertThatFeatureIsInGroup("forth", "GRP1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadNull() {
        this.testedStore.read(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadEmpty() {
        this.testedStore.read("");
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testReadNotExist() {
        this.testedStore.read("I-DONT-EXIST");
    }

    @Test
    public void testReadFullFeature() {
        this.assertFf4j.assertThatFeatureExist("forth");
        Feature f = this.testedStore.read("forth");
        Assert.assertEquals((Object)f.getUid(), (Object)"forth");
        Assert.assertTrue((f.getDescription() != null && !"".equals(f.getDescription()) ? 1 : 0) != 0);
        Assert.assertTrue((f.getPermissions() != null && !f.getPermissions().isEmpty() ? 1 : 0) != 0);
        this.assertFf4j.assertThatFeatureHasRole("forth", "ADMINISTRATOR");
        this.assertFf4j.assertThatFeatureIsInGroup("forth", "GRP1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableNull() {
        this.testedStore.enable(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableEmpty() {
        this.testedStore.enable("");
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testEnableFeatureDoesNotExist() {
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.enable("invalid-feature-id");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableNull() {
        this.testedStore.disable(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableEmpty() {
        this.testedStore.disable("");
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testDisableFeatureDoesNotExist() {
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.disable("invalid-feature-id");
    }

    @Test
    public void testEnableFeature() {
        this.assertFf4j.assertThatFeatureExist("first");
        this.testedStore.enable("first");
        this.assertFf4j.assertThatFeatureIsEnabled("first");
    }

    @Test
    public void testDisableFeature() {
        this.assertFf4j.assertThatFeatureExist("first");
        this.testedStore.disable("first");
        this.assertFf4j.assertThatFeatureIsDisabled("first");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() throws Exception {
        this.testedStore.create(null);
    }

    @Test
    public void testAddFeature() throws Exception {
        this.assertFf4j.assertThatFeatureDoesNotExist("new");
        HashSet<String> rights = new HashSet<String>(Collections.singletonList("USER"));
        Feature fp = new Feature("new", true, "description", "GRP1", rights);
        this.testedStore.create(fp);
        this.assertFf4j.assertThatStoreHasSize(6);
        this.assertFf4j.assertThatFeatureExist("new");
        this.assertFf4j.assertThatFeatureIsInGroup("new", "GRP1");
        this.testedStore.delete("new");
        this.assertFf4j.assertThatFeatureDoesNotExist("new");
    }

    @Test(expected=FeatureAlreadyExistException.class)
    public void testAddFeatureAlreadyExis() throws Exception {
        this.assertFf4j.assertThatFeatureDoesNotExist(GOLOGOLO);
        Feature fp = new Feature(GOLOGOLO, true, "description2");
        this.testedStore.create(fp);
        this.assertFf4j.assertThatFeatureExist(GOLOGOLO);
        HashSet<String> rights = new HashSet<String>(Collections.singletonList("USER"));
        Feature fp2 = new Feature(GOLOGOLO, true, "GRP1", "description3", rights);
        this.testedStore.create(fp2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeleteNull() throws Exception {
        this.testedStore.delete(null);
    }

    @Test
    public void testDeleteFeature() throws Exception {
        this.assertFf4j.assertThatFeatureExist("first");
        Feature tmpf1 = this.testedStore.read("first");
        int initialNumber = this.testedStore.readAll().size();
        this.testedStore.delete("first");
        this.assertFf4j.assertThatStoreHasSize(initialNumber - 1);
        this.assertFf4j.assertThatFeatureDoesNotExist("first");
        this.testedStore.create(tmpf1);
        this.assertFf4j.assertThatFeatureExist("first");
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testDeteleFeatureDoesnotExist() throws Exception {
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.delete("invalid-feature-id");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGrantRoleNullFeature() throws Exception {
        this.testedStore.grantRoleOnFeature(null, "ADMINISTRATOR");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGrantRoleEmptyFeature() throws Exception {
        this.testedStore.grantRoleOnFeature("", "ADMINISTRATOR");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGrantRoleNullRole() throws Exception {
        this.testedStore.grantRoleOnFeature("first", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGrantRoleEmptyRole() throws Exception {
        this.testedStore.grantRoleOnFeature("first", "");
    }

    @Test
    public void testGrantRoleToFeatureRoleDoesNotExist() throws Exception {
        this.assertFf4j.assertThatFeatureExist("first");
        this.assertFf4j.assertThatFeatureHasNotRole("first", ROLE_XYZ);
        this.testedStore.grantRoleOnFeature("first", ROLE_XYZ);
        this.assertFf4j.assertThatFeatureHasRole("first", ROLE_XYZ);
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testGrantRoleToFeatureFeatureDoesNotExist() throws Exception {
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.grantRoleOnFeature("invalid-feature-id", "USER");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRoleNullFeature() throws Exception {
        this.testedStore.removeRoleFromFeature(null, "ADMINISTRATOR");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRoleEmptyFeature() throws Exception {
        this.testedStore.removeRoleFromFeature("", "ADMINISTRATOR");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRoleNullRole() throws Exception {
        this.testedStore.removeRoleFromFeature("first", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveRoleEmptyRole() throws Exception {
        this.testedStore.removeRoleFromFeature("first", "");
    }

    @Test
    public void testDeleteRoleToFeature() throws Exception {
        this.assertFf4j.assertThatFeatureExist("first");
        this.assertFf4j.assertThatFeatureHasRole("first", "USER");
        this.testedStore.removeRoleFromFeature("first", "USER");
        this.assertFf4j.assertThatFeatureHasNotRole("first", "USER");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateNull() throws Exception {
        this.testedStore.update(null);
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testFeatureDoesNotExit() {
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.update(new Feature("invalid-feature-id"));
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testDeleteRoleFeatureDoesNotExit() {
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.removeRoleFromFeature("invalid-feature-id", "USER");
    }

    @Test
    public void testUpdateFeatureCoreData() {
        String newDescription = "new-description";
        PonderationStrategy newStrategy = new PonderationStrategy(0.12);
        this.assertFf4j.assertThatFeatureExist("first");
        Assert.assertFalse((boolean)newDescription.equals(this.testedStore.read("first").getDescription()));
        Feature fpBis = this.testedStore.read("first");
        fpBis.setDescription(newDescription);
        fpBis.setFlippingStrategy((FlippingStrategy)newStrategy);
        this.testedStore.update(fpBis);
        Feature updatedFeature = this.testedStore.read("first");
        Assert.assertTrue((boolean)newDescription.equals(updatedFeature.getDescription()));
        Assert.assertNotNull((Object)updatedFeature.getFlippingStrategy());
        Assert.assertEquals((Object)newStrategy.toString(), (Object)updatedFeature.getFlippingStrategy().toString());
    }

    @Test
    public void testUpdateFeatureMoreAutorisation() {
        HashSet<String> rights2 = new HashSet<String>(Arrays.asList("USER", "ADMINISTRATOR"));
        this.assertFf4j.assertThatFeatureExist("first");
        this.assertFf4j.assertThatFeatureHasNotRole("first", "ADMINISTRATOR");
        Feature fpBis = this.testedStore.read("first");
        fpBis.setPermissions(rights2);
        this.testedStore.update(fpBis);
        this.assertFf4j.assertThatFeatureHasRole("first", "USER");
        this.assertFf4j.assertThatFeatureHasRole("first", "ADMINISTRATOR");
    }

    @Test
    public void testUpdateFlipLessAutorisation() {
        this.assertFf4j.assertThatFeatureExist("second");
        this.assertFf4j.assertThatFeatureHasRole("second", "USER");
        this.testedStore.update(new Feature("second", false, null));
        this.assertFf4j.assertThatFeatureHasNotRole("second", "USER");
    }

    @Test
    public void testUpdateFlipMoreAutorisationNotExist() {
        this.assertFf4j.assertThatFeatureHasNotRole("first", "ROLE_NEW");
        HashSet<String> rights2 = new HashSet<String>(Arrays.asList("USER", "ROLE_NEW"));
        Feature fpBis = new Feature("first", false, "GRP1", "desci2", rights2);
        this.testedStore.update(fpBis);
        this.assertFf4j.assertThatFeatureHasRole("first", "USER");
        this.assertFf4j.assertThatFeatureHasRole("first", "ROLE_NEW");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistNull() {
        this.ff4j.getFeatureStore().exist(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistEmpty() {
        this.ff4j.getFeatureStore().exist("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistGroupNull() throws Exception {
        this.testedStore.existGroup(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistGroupEmpty() throws Exception {
        this.testedStore.existGroup("");
    }

    @Test
    public void testExistGroup() {
        this.assertFf4j.assertThatGroupExist("GRP1");
        this.assertFf4j.assertThatGroupDoesNotExist("invalid-group-name");
        Assert.assertTrue((boolean)this.testedStore.existGroup("GRP1"));
        Assert.assertFalse((boolean)this.testedStore.existGroup("invalid-group-name"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableGroupNull() throws Exception {
        this.testedStore.enableGroup(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableGroupEmpty() throws Exception {
        this.testedStore.enableGroup("");
    }

    @Test
    public void testEnableGroup() {
        this.testedStore.disable("second");
        this.testedStore.addToGroup("second", "GRP0");
        this.assertFf4j.assertThatFeatureIsDisabled("second");
        this.assertFf4j.assertThatFeatureIsInGroup("second", "GRP0");
        this.testedStore.enableGroup("GRP0");
        this.assertFf4j.assertThatFeatureIsEnabled("second");
        this.testedStore.disable("second");
    }

    @Test(expected=GroupNotFoundException.class)
    public void testEnableGroupDoesNotExist() {
        this.assertFf4j.assertThatGroupDoesNotExist("invalid-group-name");
        this.testedStore.enableGroup("invalid-group-name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableGroupNull() throws Exception {
        this.testedStore.disableGroup(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableGroupEmpty() throws Exception {
        this.testedStore.disableGroup("");
    }

    @Test
    public void testDisableGroup() {
        this.assertFf4j.assertThatFeatureIsEnabled("forth");
        this.assertFf4j.assertThatFeatureIsInGroup("forth", "GRP1");
        this.testedStore.disableGroup("GRP1");
        this.assertFf4j.assertThatFeatureIsDisabled("forth");
        this.testedStore.enable("forth");
        this.assertFf4j.assertThatFeatureIsEnabled("forth");
    }

    @Test(expected=GroupNotFoundException.class)
    public void testDisableGroupDoesNotExist() {
        this.assertFf4j.assertThatGroupDoesNotExist("invalid-group-name");
        this.testedStore.disableGroup("invalid-group-name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadGroupNull() throws Exception {
        this.testedStore.readGroup(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadGroupEmpty() throws Exception {
        this.testedStore.readGroup("");
    }

    @Test
    public void testReadGroup() {
        this.assertFf4j.assertThatGroupExist("GRP1");
        this.assertFf4j.assertThatFeatureExist("third");
        this.assertFf4j.assertThatFeatureExist("forth");
        this.testedStore.addToGroup("third", "GRP1");
        this.testedStore.addToGroup("forth", "GRP1");
        this.assertFf4j.assertThatFeatureIsInGroup("third", "GRP1");
        this.assertFf4j.assertThatFeatureIsInGroup("forth", "GRP1");
        Map group = this.testedStore.readGroup("GRP1");
        Assert.assertEquals((long)2L, (long)group.size());
        Assert.assertTrue((boolean)group.containsKey("third"));
        Assert.assertTrue((boolean)group.containsKey("forth"));
    }

    @Test(expected=GroupNotFoundException.class)
    public void testReadGroupDoesnotExist() {
        this.assertFf4j.assertThatGroupDoesNotExist("invalid-group-name");
        this.testedStore.readGroup("invalid-group-name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddToGroupFeatureNull() throws Exception {
        this.testedStore.addToGroup(null, "GRP0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddToGroupFeatureEmpty() throws Exception {
        this.testedStore.addToGroup("", "GRP0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddToGroupNull() throws Exception {
        this.testedStore.addToGroup("first", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddToGroupEmpty() throws Exception {
        this.testedStore.addToGroup("first", "");
    }

    @Test
    public void testAddToGroup() throws InterruptedException {
        this.assertFf4j.assertThatGroupHasSize(1, "GRP0");
        this.testedStore.addToGroup("first", "GRP0");
        this.assertFf4j.assertThatGroupHasSize(2, "GRP0");
        this.testedStore.removeFromGroup("first", "GRP0");
        this.assertFf4j.assertThatGroupHasSize(1, "GRP0");
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testAddToGroupFeatureDoeNotExist() {
        this.assertFf4j.assertThatGroupDoesNotExist("invalid-group-name");
        this.testedStore.addToGroup("invalid-feature-id", "GRP0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveToGroupFeatureNull() throws Exception {
        this.testedStore.removeFromGroup(null, "GRP0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveToGroupFeatureEmpty() throws Exception {
        this.testedStore.removeFromGroup("", "GRP0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveToGroupNull() throws Exception {
        this.testedStore.removeFromGroup("first", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveToGroupEmpty() throws Exception {
        this.testedStore.removeFromGroup("first", "");
    }

    @Test
    public void testRemoveFromGroup() {
        this.assertFf4j.assertThatGroupHasSize(2, "GRP1");
        this.testedStore.removeFromGroup("third", "GRP1");
        this.assertFf4j.assertThatGroupHasSize(1, "GRP1");
        this.testedStore.addToGroup("third", "GRP1");
        this.assertFf4j.assertThatGroupHasSize(2, "GRP1");
    }

    @Test(expected=GroupNotFoundException.class)
    public void testRemoveLastFeatureOfGroupDeleteGroup() throws InterruptedException {
        this.assertFf4j.assertThatGroupExist("GRP0");
        this.assertFf4j.assertThatGroupHasSize(1, "GRP0");
        this.testedStore.removeFromGroup("second", "GRP0");
        Thread.sleep(500L);
        this.testedStore.readGroup("GRP0");
    }

    @Test(expected=FeatureNotFoundException.class)
    public void testRemoveFromGroupFeatureDoeNotExist() {
        this.assertFf4j.assertThatGroupExist("GRP1");
        this.assertFf4j.assertThatFeatureDoesNotExist("invalid-feature-id");
        this.testedStore.removeFromGroup("invalid-feature-id", "GRP1");
    }

    @Test(expected=GroupNotFoundException.class)
    public void testRemoveFromGroupDoesNotExist() {
        this.assertFf4j.assertThatFeatureExist("first");
        this.assertFf4j.assertThatGroupDoesNotExist("invalid-group-name");
        this.testedStore.removeFromGroup("first", "invalid-group-name");
    }

    @Test
    public void testRemoveFromGroupIfNotInGroup() {
        this.assertFf4j.assertThatFeatureExist("first");
        this.assertFf4j.assertThatGroupExist("GRP1");
        this.testedStore.removeFromGroup("first", "GRP1");
    }

    @Test
    public void testReadAllGroup() {
        this.testedStore.addToGroup("second", "GRP0");
        this.assertFf4j.assertThatStoreHasNumberOfGroups(2);
        this.assertFf4j.assertThatGroupExist("GRP0");
        this.assertFf4j.assertThatGroupExist("GRP1");
        Set groups = this.testedStore.readAllGroups();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertTrue((boolean)groups.contains("GRP0"));
        Assert.assertTrue((boolean)groups.contains("GRP1"));
    }

    @Test
    public void testUpdateEditFlippingStrategy() {
        this.assertFf4j.assertThatFeatureExist("third");
        Feature myFeature = this.ff4j.getFeatureStore().read("third");
        myFeature.setFlippingStrategy((FlippingStrategy)new PonderationStrategy(0.1));
        this.testedStore.update(myFeature);
        this.assertFf4j.assertThatFeatureHasFlippingStrategy("third");
    }

    @Test
    public void testUpdateRemoveFlippingStrategy() {
        this.assertFf4j.assertThatFeatureExist("third");
        Feature myFeature = this.ff4j.getFeatureStore().read("third");
        myFeature.setFlippingStrategy((FlippingStrategy)new PonderationStrategy(0.1));
        this.testedStore.update(myFeature);
        this.assertFf4j.assertThatFeatureHasFlippingStrategy("third");
        Feature myFeature2 = this.ff4j.getFeatureStore().read("third");
        myFeature2.setFlippingStrategy(null);
        this.testedStore.update(myFeature2);
        this.assertFf4j.assertThatFeatureDoesNotHaveFlippingStrategy("third");
    }

    @Test
    public void testUpdateAddFlippingStrategy() {
        this.assertFf4j.assertThatFeatureExist("second");
        this.assertFf4j.assertThatFeatureDoesNotHaveFlippingStrategy("second");
        Feature myFeature = this.ff4j.getFeatureStore().read("second");
        myFeature.setFlippingStrategy((FlippingStrategy)new PonderationStrategy(0.1));
        this.testedStore.update(myFeature);
        this.assertFf4j.assertThatFeatureHasFlippingStrategy("second");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDonotUpdateNullFeature() {
        this.testedStore.update(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDonotDeleteNull() {
        this.testedStore.delete(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDonotDeleteEmpty() {
        this.testedStore.delete("");
    }

    @Test
    public void testClear() {
        Assert.assertNotNull((Object)this.testedStore);
        Map before = this.testedStore.readAll();
        Assert.assertFalse((boolean)before.isEmpty());
        this.testedStore.clear();
        Assert.assertTrue((boolean)this.testedStore.readAll().isEmpty());
        for (Map.Entry pName : before.entrySet()) {
            this.testedStore.create((Feature)pName.getValue());
        }
    }

    @Test
    public void testUpdateAddProperty() {
        this.assertFf4j.assertThatFeatureExist("second");
        this.assertFf4j.assertThatFeatureHasNotProperty("second", "p1");
        Feature myFeature = this.ff4j.getFeatureStore().read("second");
        PropertyString p1 = new PropertyString("p1", "v1", Util.set((Object[])new String[]{"v1", "v2"}));
        myFeature.getCustomProperties().put(p1.getName(), p1);
        this.testedStore.update(myFeature);
        this.assertFf4j.assertThatFeatureHasProperty("second", "p1");
    }

    @Test
    public void testUpdateRemoveProperty() {
        this.assertFf4j.assertThatFeatureExist("first");
        Feature myFeature = this.ff4j.getFeatureStore().read("first");
        myFeature.getCustomProperties().remove("ppint");
        this.testedStore.update(myFeature);
        this.assertFf4j.assertThatFeatureHasNotProperty("first", "p1");
    }

    @Test
    public void testUpdateEditPropertyValue() {
        PropertyString p1;
        this.assertFf4j.assertThatFeatureExist("first");
        Feature myFeature = this.ff4j.getFeatureStore().read("first");
        if (myFeature.getCustomProperties().isEmpty()) {
            p1 = new PropertyString(PPSTRING);
            p1.setValue((Object)"hello");
            myFeature.getCustomProperties().put(p1.getName(), p1);
            this.testedStore.update(myFeature);
        }
        this.assertFf4j.assertThatFeatureHasProperty("first", PPSTRING);
        Assert.assertEquals((Object)"hello", (Object)((Property)this.ff4j.getFeatureStore().read("first").getCustomProperties().get(PPSTRING)).asString());
        myFeature = this.ff4j.getFeatureStore().read("first");
        p1 = new PropertyString(PPSTRING, "goodbye");
        myFeature.getCustomProperties().put(p1.getName(), p1);
        this.testedStore.update(myFeature);
        Assert.assertEquals((Object)"goodbye", (Object)((Property)this.ff4j.getFeatureStore().read("first").getCustomProperties().get(PPSTRING)).asString());
    }

    @Test
    public void testUpdateEditPropertyAddFixedValues() {
        this.assertFf4j.assertThatFeatureExist("first");
        Feature myFeature = this.ff4j.getFeatureStore().read("first");
        myFeature.addProperty((Property)new PropertyInt(DIGIT_VALUE, Integer.valueOf(2), Util.set((Object[])new Integer[]{0, 1, 2, 3})));
        this.ff4j.getFeatureStore().update(myFeature);
        this.assertFf4j.assertThatFeatureHasProperty("first", DIGIT_VALUE);
        Set fixValues = ((Property)this.ff4j.getFeatureStore().read("first").getCustomProperties().get(DIGIT_VALUE)).getFixedValues();
        Assert.assertEquals((long)4L, (long)fixValues.size());
        myFeature = this.ff4j.getFeatureStore().read("first");
        PropertyInt p1 = new PropertyInt(DIGIT_VALUE);
        p1.setFixedValues(Util.set((Object[])new Integer[]{0, 1, 2, 3, 4}));
        p1.setValue((Object)4);
        myFeature.getCustomProperties().put(p1.getName(), p1);
        this.testedStore.update(myFeature);
        Set fixValues2 = ((Property)this.ff4j.getFeatureStore().read("first").getCustomProperties().get(DIGIT_VALUE)).getFixedValues();
        Assert.assertEquals((long)5L, (long)fixValues2.size());
    }

    @Test
    public void testUpdateEditPropertyRemoveFixedValues() {
        this.assertFf4j.assertThatFeatureExist("first");
        Feature myFeature = this.ff4j.getFeatureStore().read("first");
        myFeature.addProperty((Property)new PropertyString(REGION_IDENTIFIER, "AMER", Util.set((Object[])new String[]{"AMER", "SSSS", "EAST"})));
        this.testedStore.update(myFeature);
        this.assertFf4j.assertThatFeatureHasProperty("first", REGION_IDENTIFIER);
        Set fixValues = ((Property)this.ff4j.getFeatureStore().read("first").getCustomProperties().get(REGION_IDENTIFIER)).getFixedValues();
        Assert.assertEquals((long)3L, (long)fixValues.size());
        myFeature = this.ff4j.getFeatureStore().read("first");
        PropertyString p1 = new PropertyString(REGION_IDENTIFIER);
        p1.setValue((Object)"AMER");
        p1.setFixedValues(Util.set((Object[])new String[]{"AMER", "SSSS"}));
        myFeature.getCustomProperties().put(p1.getName(), p1);
        this.testedStore.update(myFeature);
        Set fixValues2 = ((Property)this.ff4j.getFeatureStore().read("first").getCustomProperties().get(REGION_IDENTIFIER)).getFixedValues();
        Assert.assertEquals((long)2L, (long)fixValues2.size());
    }
}

