/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.test;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.ff4j.FF4j;
import org.junit.Assert;

public class AssertFf4j {
    public static final String IS_MANDATORY = "' is mandatory";
    public static final String FEATURE = "Feature '";
    private final FF4j ff4j;
    private int pause;

    public AssertFf4j(FF4j cff4j) {
        this.ff4j = cff4j;
        this.pause = 0;
    }

    public void setPause(int pause) {
        this.pause = pause;
    }

    public final AssertFf4j assertThatFeatureExist(String featureName) {
        Assert.assertTrue((String)(FEATURE + featureName + IS_MANDATORY), (boolean)this.ff4j.exist(featureName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatPropertyExist(String propertyName) {
        Assert.assertTrue((String)("Property '" + propertyName + IS_MANDATORY), (boolean)this.ff4j.getPropertiesStore().existProperty(propertyName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureDoesNotExist(String featureName) {
        Assert.assertFalse((String)(FEATURE + featureName + "' must not exist"), (boolean)this.ff4j.exist(featureName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatPropertyDoesNotExist(String propertyName) {
        Assert.assertFalse((String)("Property '" + propertyName + IS_MANDATORY), (boolean)this.ff4j.getPropertiesStore().existProperty(propertyName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureFlipped(String featureName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertTrue((String)("'" + featureName + "' is not flipped where it should"), (boolean)this.ff4j.check(featureName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureNotFlipped(String featureName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertFalse((String)("'" + featureName + "' is flipped where it shouldn't"), (boolean)this.ff4j.check(featureName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatCurrentUserIsAllowedOnFeature(String featureName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertTrue((boolean)this.ff4j.isAllowed(this.ff4j.getFeature(featureName)));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatCurrentUserIsNotAllowedOnFeature(String featureName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertFalse((boolean)this.ff4j.isAllowed(this.ff4j.getFeature(featureName)));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatStoreHasSize(int expectedNumber) {
        Assert.assertEquals((long)expectedNumber, (long)this.ff4j.getFeatureStore().readAll().size());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatPropertyStoreHasSize(int expectedNumber) {
        Assert.assertEquals((long)expectedNumber, (long)this.ff4j.getPropertiesStore().listPropertyNames().size());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatStoreHasNumberOfGroups(int expectedNumber) {
        Set groups = this.ff4j.getFeatureStore().readAllGroups();
        Assert.assertEquals((long)expectedNumber, (long)groups.size());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureHasRole(String featureName, String roleName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertTrue((String)("'" + featureName + "' has no roles"), (!this.ff4j.getFeature(featureName).getPermissions().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)("'" + featureName + "' has not role '" + roleName + "'"), (boolean)this.ff4j.getFeature(featureName).getPermissions().contains(roleName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureHasNotRole(String featureName, String roleName) {
        this.assertThatFeatureExist(featureName);
        if (null != this.ff4j.getFeature(featureName).getPermissions()) {
            Assert.assertFalse((String)("Feature must no contain role " + roleName), (boolean)this.ff4j.getFeature(featureName).getPermissions().contains(roleName));
        }
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureIsInGroup(String featureName, String groupName) {
        this.assertThatFeatureExist(featureName);
        String group = this.ff4j.getFeature(featureName).getGroup();
        Assert.assertTrue((String)("'" + featureName + "' must be in group '" + groupName + "' but is in <" + group + ">"), (group != null && groupName.equals(group) ? 1 : 0) != 0);
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureNotInGroup(String featureName, String groupName) {
        this.assertThatFeatureExist(featureName);
        String group = this.ff4j.getFeature(featureName).getGroup();
        Assert.assertTrue((group == null || !groupName.equals(group) ? 1 : 0) != 0);
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureIsEnabled(String featureName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertTrue((boolean)this.ff4j.getFeatureStore().read(featureName).isEnable());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureIsDisabled(String featureName) {
        this.assertThatFeatureExist(featureName);
        Assert.assertFalse((String)("'" + featureName + "' must be disabled"), (boolean)this.ff4j.getFeatureStore().read(featureName).isEnable());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatGroupExist(String groupName) {
        Assert.assertTrue((String)("Group '" + groupName + " ' does no exist"), (boolean)this.ff4j.getFeatureStore().existGroup(groupName));
        this.waitSomeSeconds();
        return this;
    }

    public AssertFf4j assertThatGroupDoesNotExist(String groupName) {
        this.waitSomeSeconds();
        Assert.assertFalse((String)("Group '" + groupName + " ' does no exist"), (boolean)this.ff4j.getFeatureStore().existGroup(groupName));
        return this;
    }

    public final AssertFf4j assertThatGroupHasSize(int expected, String groupName) {
        this.assertThatGroupExist(groupName);
        Assert.assertEquals((long)expected, (long)this.ff4j.getFeatureStore().readGroup(groupName).size());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureHasFlippingStrategy(String featureName) {
        Assert.assertNotNull((String)(FEATURE + featureName + "' must have a FlippingStrategy but doesn't"), (Object)this.ff4j.getFeature(featureName).getFlippingStrategy());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureDoesNotHaveFlippingStrategy(String featureName) {
        Assert.assertNull((String)(FEATURE + featureName + "' must not have a flipping strategy"), (Object)this.ff4j.getFeature(featureName).getFlippingStrategy());
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureHasProperties(String featureName) {
        this.assertThatFeatureExist(featureName);
        Map properties = this.ff4j.getFeature(featureName).getCustomProperties();
        Assert.assertTrue((String)"Properties are required", (properties != null && properties.size() > 0 ? 1 : 0) != 0);
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureDoesNotHaveProperties(String featureName) {
        this.assertThatFeatureExist(featureName);
        Map properties = this.ff4j.getFeature(featureName).getCustomProperties();
        Assert.assertTrue((String)"Properties are required", (properties == null || properties.isEmpty() ? 1 : 0) != 0);
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureHasProperty(String featureName, String propertyName) {
        this.assertThatFeatureHasProperties(featureName);
        Map properties = this.ff4j.getFeature(featureName).getCustomProperties();
        Assert.assertTrue((String)("Feature must contain property " + propertyName), (boolean)properties.containsKey(propertyName));
        this.waitSomeSeconds();
        return this;
    }

    public final AssertFf4j assertThatFeatureHasNotProperty(String featureName, String propertyName) {
        this.assertThatFeatureExist(featureName);
        Map properties = this.ff4j.getFeature(featureName).getCustomProperties();
        Assert.assertTrue((String)("Feature must contain property " + propertyName), (properties == null || !properties.containsKey(propertyName) ? 1 : 0) != 0);
        this.waitSomeSeconds();
        return this;
    }

    public void waitSomeSeconds() {
        try {
            TimeUnit.SECONDS.sleep(this.pause);
        }
        catch (InterruptedException e) {
            System.err.println("An error occurs when waiting" + e.getMessage());
        }
    }
}

