/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.test.propertystore;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.ff4j.FF4j;
import org.ff4j.core.FeatureStore;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyDate;
import org.ff4j.property.PropertyLogLevel;
import org.ff4j.property.PropertyString;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.store.InMemoryFeatureStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class PropertyStoreTestSupport {
    public static final String ADD_PROPERTY_O_KSIMPLE = "addPropertyOKsimple";
    public static final String READ_OK_FIXED = "readOKFixed";
    public static final String INVALID = "invalid";
    public static final String UPDATE_OK = "updateOK";
    public static final String DELETE_OK = "deleteOK";
    protected FF4j ff4j = null;
    protected PropertyStore testedStore;
    protected FeatureStore defaultStore = new InMemoryFeatureStore();

    @Before
    public void setUp() throws Exception {
        this.ff4j = new FF4j();
        this.ff4j.setPropertiesStore(this.initPropertyStore());
        this.testedStore = this.ff4j.getConcretePropertyStore();
    }

    protected abstract PropertyStore initPropertyStore();

    @Test
    public void multipleSchemaCreationOk() {
        this.testedStore.createSchema();
        this.testedStore.createSchema();
    }

    @Test(expected=IllegalArgumentException.class)
    public void existKONull() {
        this.testedStore.existProperty(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void existKOEmpty() {
        this.testedStore.existProperty("");
    }

    @Test
    public void existfalse() {
        Assert.assertFalse((boolean)this.testedStore.existProperty("propertyThatNotExist"));
    }

    @Test
    public void addPropertyOKsimple() {
        Assert.assertFalse((boolean)this.testedStore.existProperty(ADD_PROPERTY_O_KSIMPLE));
        this.testedStore.createProperty((Property)new PropertyString(ADD_PROPERTY_O_KSIMPLE, "ff4j"));
        Assert.assertTrue((boolean)this.testedStore.existProperty(ADD_PROPERTY_O_KSIMPLE));
    }

    @Test
    public void addPropertyOKLogLevel() {
        this.testedStore.createProperty((Property)new PropertyLogLevel("logi", PropertyLogLevel.LogLevel.DEBUG));
        Assert.assertTrue((boolean)this.testedStore.existProperty("logi"));
    }

    @Test
    public void addPropertyOKDate() {
        this.testedStore.createProperty((Property)new PropertyDate("ddate", new Date()));
        Assert.assertTrue((boolean)this.testedStore.existProperty("ddate"));
    }

    @Test(expected=PropertyAlreadyExistException.class)
    public void addPropertyKOAlreadyExist() {
        this.testedStore.createProperty((Property)new PropertyLogLevel("log", PropertyLogLevel.LogLevel.DEBUG));
        Assert.assertTrue((boolean)this.testedStore.existProperty("log"));
        this.testedStore.createProperty((Property)new PropertyLogLevel("log", PropertyLogLevel.LogLevel.DEBUG));
    }

    @Test(expected=IllegalArgumentException.class)
    public void addPropertyKONull() {
        this.testedStore.createProperty(null);
    }

    @Test
    public void readOK() {
        this.testedStore.createProperty((Property)new PropertyString("toto", "ff4j"));
        Property ap = this.testedStore.readProperty("toto");
        Assert.assertNotNull((Object)ap);
        Assert.assertNotNull((Object)ap.getName());
        Assert.assertEquals((Object)"toto", (Object)ap.getName());
        Assert.assertEquals((Object)"ff4j", (Object)ap.getValue());
        Assert.assertEquals((Object)"ff4j", (Object)ap.asString());
        Assert.assertNull((Object)ap.getFixedValues());
    }

    @Test
    public void readOKFixed() {
        this.testedStore.createProperty((Property)new PropertyLogLevel(READ_OK_FIXED, PropertyLogLevel.LogLevel.ERROR));
        Property log = this.testedStore.readProperty(READ_OK_FIXED);
        Assert.assertNotNull((Object)log);
        Assert.assertNotNull((Object)log.getName());
        Assert.assertEquals((Object)READ_OK_FIXED, (Object)log.getName());
        Assert.assertEquals((Object)PropertyLogLevel.LogLevel.ERROR, (Object)log.getValue());
        Assert.assertEquals((Object)"ERROR", (Object)log.asString());
        Assert.assertNotNull((Object)log.getFixedValues());
    }

    @Test(expected=IllegalArgumentException.class)
    public void readKOnull() {
        this.testedStore.readProperty(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void readKOempty() {
        this.testedStore.readProperty("");
    }

    @Test(expected=PropertyNotFoundException.class)
    public void readKOnotExist() {
        Assert.assertFalse((boolean)this.testedStore.existProperty(INVALID));
        this.testedStore.readProperty(INVALID);
    }

    @Test(expected=PropertyNotFoundException.class)
    public void updateKOdoesnotExist() {
        Assert.assertFalse((boolean)this.testedStore.existProperty(INVALID));
        this.testedStore.updateProperty(INVALID, "aa");
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateKOnull() {
        this.testedStore.updateProperty(null, "aa");
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateKONullBis() {
        this.testedStore.updateProperty(null);
    }

    @Test(expected=PropertyNotFoundException.class)
    public void updateKOPropertyNotFound() {
        PropertyString ps = new PropertyString("does-not-exist");
        this.testedStore.updateProperty((Property)ps);
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateKOempty() {
        this.testedStore.updateProperty("", "aa");
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateKOInvalidValue() {
        this.testedStore.createProperty((Property)new PropertyLogLevel("updateKOInvalidValue", PropertyLogLevel.LogLevel.ERROR));
        this.testedStore.updateProperty("updateKOInvalidValue", "KO");
    }

    @Test
    public void updateOK() {
        this.testedStore.createProperty((Property)new PropertyLogLevel(UPDATE_OK, PropertyLogLevel.LogLevel.ERROR));
        this.testedStore.updateProperty(UPDATE_OK, "INFO");
        Assert.assertEquals((Object)PropertyLogLevel.LogLevel.INFO, (Object)this.testedStore.readProperty(UPDATE_OK).getValue());
    }

    @Test
    public void updateOKProperties() {
        this.testedStore.createProperty((Property)new PropertyLogLevel("logX", PropertyLogLevel.LogLevel.ERROR));
        PropertyLogLevel pll = new PropertyLogLevel("logX", PropertyLogLevel.LogLevel.INFO);
        this.testedStore.updateProperty((Property)pll);
        Assert.assertEquals((Object)PropertyLogLevel.LogLevel.INFO, (Object)this.testedStore.readProperty("logX").getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteKOnull() {
        this.testedStore.deleteProperty(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteKOempty() {
        this.testedStore.deleteProperty("");
    }

    @Test(expected=PropertyNotFoundException.class)
    public void deleteKOdoesnotexist() {
        Assert.assertFalse((boolean)this.testedStore.existProperty(INVALID));
        this.testedStore.deleteProperty(INVALID);
    }

    @Test
    public void deleteOK() {
        this.testedStore.createProperty((Property)new PropertyString(DELETE_OK, "ff4j"));
        Assert.assertTrue((boolean)this.testedStore.existProperty(DELETE_OK));
        this.testedStore.deleteProperty(DELETE_OK);
        Assert.assertFalse((boolean)this.testedStore.existProperty(DELETE_OK));
    }

    @Test
    public void existfilled() {
        Assert.assertTrue((boolean)this.testedStore.existProperty("a"));
        Assert.assertFalse((boolean)this.testedStore.existProperty("koala"));
    }

    @Test
    public void valueFixed() {
        Assert.assertTrue((boolean)this.testedStore.existProperty("a"));
        Assert.assertEquals((Object)"AMER", (Object)this.testedStore.readProperty("a").getValue());
    }

    @Test
    public void listPropertyNames() {
        Set proNames = this.testedStore.listPropertyNames();
        Assert.assertTrue((boolean)proNames.contains("a"));
    }

    @Test
    public void readAllProperties() {
        Assert.assertNotNull((Object)this.testedStore);
        Map mapsOf = this.testedStore.readAllProperties();
        Assert.assertTrue((boolean)mapsOf.containsKey("a"));
        Assert.assertTrue((boolean)mapsOf.containsKey("b"));
    }

    @Test
    public void clear() {
        Assert.assertNotNull((Object)this.testedStore);
        Map before = this.testedStore.readAllProperties();
        Assert.assertFalse((boolean)before.isEmpty());
        this.testedStore.clear();
        Assert.assertTrue((boolean)this.testedStore.readAllProperties().isEmpty());
        for (Map.Entry pName : before.entrySet()) {
            this.testedStore.createProperty((Property)pName.getValue());
        }
    }
}

