/*
 * Decompiled with CFR 0.152.
 */
package org.finnpic.businessid;

import java.io.Serializable;
import org.finnpic.Parsable;
import org.finnpic.businessid.BusinessId;
import org.finnpic.businessid.BusinessId$ChecksumOk$;
import org.finnpic.businessid.BusinessId$SumMod11ResultsIn1$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BusinessId$
implements Parsable<BusinessId> {
    public static final BusinessId$ MODULE$ = new BusinessId$();

    static {
        Parsable.$init$(MODULE$);
    }

    @Override
    public Object fromStringUnsafe(String input) {
        return Parsable.fromStringUnsafe$(this, input);
    }

    @Override
    public Object fromStringU(String input) {
        return Parsable.fromStringU$(this, input);
    }

    public Either<String, BusinessId> apply(String input) {
        return this.fromString(input);
    }

    @Override
    public Either<String, BusinessId> fromString(String input) {
        String string;
        Either<String, BusinessId> either;
        String string2;
        String canonized = input.trim();
        String string3 = canonized;
        if (string3 != null && (string2 = string3).length() != 9) {
            either = package$.MODULE$.Left().apply((Object)"Invalid business id: ''. Business id should have 9 characters, but was 0 characters.");
        } else if (string3 != null && (string = string3).length() == 9) {
            either = this.createFromStringOfCorrectLength(input, canonized);
        } else {
            throw new MatchError((Object)string3);
        }
        return either;
    }

    public Either<String, BusinessId> createFromStringOfCorrectLength(String originalInput, String canonizedInput) {
        Left left;
        Predef$.MODULE$.assert(canonizedInput.length() == 9);
        if (canonizedInput.matches("[\\d]{7}-[\\d]")) {
            Right right;
            BusinessId.ChecksumValidationResult checksumValidationResult = this.checksum(canonizedInput);
            if (BusinessId$ChecksumOk$.MODULE$.equals(checksumValidationResult)) {
                right = package$.MODULE$.Right().apply((Object)new BusinessId(canonizedInput));
            } else if (checksumValidationResult instanceof BusinessId.InvalidChecksumDigitInInput) {
                BusinessId.InvalidChecksumDigitInInput invalidChecksumDigitInInput = (BusinessId.InvalidChecksumDigitInInput)checksumValidationResult;
                int was = invalidChecksumDigitInInput.was();
                int shouldHaveBeen = invalidChecksumDigitInInput.shouldHaveBeen();
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(77).append("Invalid business id: '").append(originalInput).append("'. The checksum character '").append(was).append("' is wrong: it should be '").append(shouldHaveBeen).append("'.").toString());
            } else if (BusinessId$SumMod11ResultsIn1$.MODULE$.equals(checksumValidationResult)) {
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(64).append("Invalid business id: '").append(originalInput).append("'. The checksum value of 1 is not allowed.").toString());
            } else {
                throw new MatchError((Object)checksumValidationResult);
            }
            left = right;
        } else {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(75).append("Invalid business id: '").append(originalInput).append("'. Business id should contain only digits and a dash.").toString());
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BusinessId.ChecksumValidationResult checksum(String input) {
        Left left;
        List weights = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 9, 10, 5, 8, 4, 2}));
        int[] numbers = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.charArrayOps(input.substring(0, 7).toCharArray()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1)))), (ClassTag)ClassTag$.MODULE$.Int());
        Seq zipped = (Seq)weights.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(numbers));
        Seq multiplied = (Seq)zipped.map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)BusinessId$.$anonfun$checksum$2(x0$1)));
        int sum = BoxesRunTime.unboxToInt((Object)multiplied.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int sumMod11 = sum % 11;
        int inputChecksumDigit = RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(input.charAt(input.length() - 1)));
        int n = sumMod11;
        switch (n) {
            case 0: {
                left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)0));
                break;
            }
            case 1: {
                left = package$.MODULE$.Left().apply((Object)BusinessId$SumMod11ResultsIn1$.MODULE$);
                break;
            }
            default: {
                if (!RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 10).contains(n)) throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(11 - n)));
                break;
            }
        }
        Left expectedChecksumDigit = left;
        boolean bl = false;
        Right right = null;
        Left left2 = expectedChecksumDigit;
        if (left2 instanceof Left) {
            Left left3 = left2;
            BusinessId.ChecksumValidationResult invalidResult = (BusinessId.ChecksumValidationResult)left3.value();
            return invalidResult;
        }
        if (left2 instanceof Right) {
            bl = true;
            right = (Right)left2;
            int expectedDigit = BoxesRunTime.unboxToInt((Object)right.value());
            if (inputChecksumDigit == expectedDigit) {
                return BusinessId$ChecksumOk$.MODULE$;
            }
        }
        if (!bl) throw new MatchError((Object)left2);
        int expectedDigit = BoxesRunTime.unboxToInt((Object)right.value());
        return new BusinessId.InvalidChecksumDigitInInput(inputChecksumDigit, expectedDigit);
    }

    public static final /* synthetic */ int $anonfun$checksum$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int w = tuple2._1$mcI$sp();
        int n = tuple2._2$mcI$sp();
        int n2 = w * n;
        return n2;
    }

    private BusinessId$() {
    }
}

