/*
 * Decompiled with CFR 0.152.
 */
package org.finnpic;

import org.finnpic.Female$;
import org.finnpic.Gender;
import org.finnpic.Male$;
import org.finnpic.Pic;
import org.finnpic.Pic$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Pic$ {
    public static final Pic$ MODULE$;
    private final int finnishLegalAge;
    private final Pic.ValidationRule birthDatePartMustBeNumeric;
    private final Pic.ValidationRule dayOfBirthDatePartMustBeInRangeOf1To31;
    private final Pic.ValidationRule monthOfBirthDatePartMustBeInRangeOf1To12;
    private final Pic.ValidationRule signMustHaveAcceptableValue;
    private final Pic.ValidationRule individualNumberMustBeNumeric;
    private final List<Pic.ValidationRule> validationRules;
    private final char[] controlChars;

    static {
        new Pic$();
    }

    public int finnishLegalAge() {
        return this.finnishLegalAge;
    }

    public Either<String, Pic> apply(String input) {
        return this.fromString(input);
    }

    public Either<String, Pic> fromString(String input) {
        String string;
        block4: {
            Left left;
            block3: {
                String string2;
                block2: {
                    String string3;
                    string = input.trim().toUpperCase();
                    if (string == null || (string3 = string).length() == 11) break block2;
                    left = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. PIC should have 11 characters, but was ", " characters."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string3, BoxesRunTime.boxToInteger((int)string3.length())})));
                    break block3;
                }
                if (string == null || (string2 = string).length() != 11) break block4;
                left = this.createFromStringOfCorrectLength(input, string2);
            }
            return left;
        }
        throw new MatchError((Object)string);
    }

    public Pic fromStringUnsafe(String input) {
        Either<String, Pic> either = this.fromString(input);
        if (either instanceof Left) {
            Left left = (Left)either;
            String errorMessage = (String)left.a();
            throw new IllegalArgumentException(errorMessage);
        }
        if (either instanceof Right) {
            Pic pic;
            Right right = (Right)either;
            Pic pic2 = pic = (Pic)right.b();
            return pic2;
        }
        throw new MatchError(either);
    }

    public Pic fromStringU(String input) {
        return this.fromStringUnsafe(input);
    }

    private Either<String, Pic> createFromStringOfCorrectLength(String originalInput, String cleanedInput) {
        String birthDatePart = cleanedInput.substring(0, 6);
        String sign = cleanedInput.substring(6, 7);
        String individualNumber = cleanedInput.substring(7, 10);
        String controlCharacter = cleanedInput.substring(10, 11);
        return this.createFromSubstrings(new Pic.PicParts(originalInput, cleanedInput, birthDatePart, sign, individualNumber, controlCharacter));
    }

    private Pic.ValidationRule birthDatePartMustBeNumeric() {
        return this.birthDatePartMustBeNumeric;
    }

    private Pic.ValidationRule dayOfBirthDatePartMustBeInRangeOf1To31() {
        return this.dayOfBirthDatePartMustBeInRangeOf1To31;
    }

    private Pic.ValidationRule monthOfBirthDatePartMustBeInRangeOf1To12() {
        return this.monthOfBirthDatePartMustBeInRangeOf1To12;
    }

    private Pic.ValidationRule signMustHaveAcceptableValue() {
        return this.signMustHaveAcceptableValue;
    }

    private Pic.ValidationRule individualNumberMustBeNumeric() {
        return this.individualNumberMustBeNumeric;
    }

    private List<Pic.ValidationRule> validationRules() {
        return this.validationRules;
    }

    private Either<String, Pic> createFromSubstrings(Pic.PicParts pp) {
        Option option;
        block4: {
            Left left;
            block3: {
                block2: {
                    Option failedValidationRule = this.validationRules().find((Function1)new Serializable(pp){
                        public static final long serialVersionUID = 0L;
                        private final Pic.PicParts pp$2;

                        public final boolean apply(Pic.ValidationRule vr) {
                            return !BoxesRunTime.unboxToBoolean((Object)vr.predicate().apply((Object)this.pp$2));
                        }
                        {
                            this.pp$2 = pp$2;
                        }
                    });
                    option = failedValidationRule;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Pic.ValidationRule rule = (Pic.ValidationRule)some.x();
                    left = package$.MODULE$.Left().apply(rule.errorMessageGenerator().apply((Object)pp));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                left = this.createFromValidParts(pp);
            }
            return left;
        }
        throw new MatchError((Object)option);
    }

    private Either<String, Pic> createFromValidParts(Pic.PicParts pp) {
        Try try_;
        block11: {
            Left left;
            block8: {
                Right right;
                block10: {
                    block9: {
                        int n;
                        block7: {
                            char expectedControlCharacter = this.calculateExpectedControlCharacter(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)pp.birthDatePart()).append((Object)pp.individualNumber()).toString())).toLong());
                            if (pp.controlCharacter().charAt(0) == expectedControlCharacter) break block7;
                            left = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The control character ('", "') is wrong: it should be '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.controlCharacter(), BoxesRunTime.boxToCharacter((char)expectedControlCharacter)})));
                            break block8;
                        }
                        Product gender = new StringOps(Predef$.MODULE$.augmentString(pp.individualNumber())).toInt() % 2 == 0 ? Female$.MODULE$ : Male$.MODULE$;
                        char c = pp.sign().charAt(0);
                        switch (c) {
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                            }
                            case 'A': {
                                n = 2000;
                                break;
                            }
                            case '-': {
                                n = 1900;
                                break;
                            }
                            case '+': {
                                n = 1800;
                            }
                        }
                        int century = n;
                        int yearWithinCentury = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(4, 6))).toInt();
                        int birthYear = century + yearWithinCentury;
                        int birthMonth = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(2, 4))).toInt();
                        int birthDay = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(0, 2))).toInt();
                        Pic candidate = new Pic(pp.cleanedInput(), (Gender)gender, birthYear, birthMonth, birthDay);
                        try_ = Try$.MODULE$.apply((Function0)new anonfun.12(candidate));
                        if (!(try_ instanceof Success)) break block9;
                        right = package$.MODULE$.Right().apply((Object)candidate);
                        break block10;
                    }
                    if (!(try_ instanceof Failure)) break block11;
                    right = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The birth date is impossible, this day does not exist on the calendar: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.birthDatePart()})));
                }
                left = right;
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public char[] controlChars() {
        return this.controlChars;
    }

    public char calculateExpectedControlCharacter(long input) {
        int remainder = (int)(input % 31L);
        return this.controlChars()[remainder];
    }

    private Pic$() {
        MODULE$ = this;
        this.finnishLegalAge = 18;
        this.birthDatePartMustBeNumeric = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new anonfun.1(), (Function1<Pic.PicParts, String>)new anonfun.2());
        this.dayOfBirthDatePartMustBeInRangeOf1To31 = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new anonfun.3(), (Function1<Pic.PicParts, String>)new anonfun.4());
        this.monthOfBirthDatePartMustBeInRangeOf1To12 = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new anonfun.5(), (Function1<Pic.PicParts, String>)new anonfun.6());
        this.signMustHaveAcceptableValue = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new anonfun.7(), (Function1<Pic.PicParts, String>)new anonfun.8());
        this.individualNumberMustBeNumeric = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new anonfun.9(), (Function1<Pic.PicParts, String>)new anonfun.10());
        this.validationRules = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pic.ValidationRule[]{this.birthDatePartMustBeNumeric(), this.dayOfBirthDatePartMustBeInRangeOf1To31(), this.monthOfBirthDatePartMustBeInRangeOf1To12(), this.signMustHaveAcceptableValue(), this.individualNumberMustBeNumeric()}));
        this.controlChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};
    }
}

