/*
 * Decompiled with CFR 0.152.
 */
package org.finnpic;

import java.io.Serializable;
import org.finnpic.Female$;
import org.finnpic.Gender;
import org.finnpic.Male$;
import org.finnpic.Pic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Pic$ {
    public static Pic$ MODULE$;
    private final int finnishLegalAge;
    private final Pic.ValidationRule birthDatePartMustBeNumeric;
    private final Pic.ValidationRule dayOfBirthDatePartMustBeInRangeOf1To31;
    private final Pic.ValidationRule monthOfBirthDatePartMustBeInRangeOf1To12;
    private final Pic.ValidationRule signMustHaveAcceptableValue;
    private final Pic.ValidationRule individualNumberMustBeNumeric;
    private final List<Pic.ValidationRule> validationRules;
    private final char[] controlChars;

    static {
        new Pic$();
    }

    public int finnishLegalAge() {
        return this.finnishLegalAge;
    }

    public Either<String, Pic> apply(String input) {
        return this.fromString(input);
    }

    public Either<String, Pic> fromString(String input) {
        String string;
        Left left;
        String string2;
        String string3 = input.trim().toUpperCase();
        if (string3 != null && (string2 = string3).length() != 11) {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(68).append("Invalid PIC: '").append(string2).append("'. PIC should have 11 characters, but was ").append(string2.length()).append(" characters.").toString());
        } else if (string3 != null && (string = string3).length() == 11) {
            left = this.createFromStringOfCorrectLength(input, string);
        } else {
            throw new MatchError((Object)string3);
        }
        return left;
    }

    public Pic fromStringUnsafe(String input) {
        Pic pic;
        Either<String, Pic> either = this.fromString(input);
        if (either instanceof Left) {
            Left left = (Left)either;
            String errorMessage = (String)left.value();
            throw new IllegalArgumentException(errorMessage);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Pic pic2 = pic = (Pic)right.value();
        return pic2;
    }

    public Pic fromStringU(String input) {
        return this.fromStringUnsafe(input);
    }

    private Either<String, Pic> createFromStringOfCorrectLength(String originalInput, String cleanedInput) {
        String birthDatePart = cleanedInput.substring(0, 6);
        String sign = cleanedInput.substring(6, 7);
        String individualNumber = cleanedInput.substring(7, 10);
        String controlCharacter = cleanedInput.substring(10, 11);
        return this.createFromSubstrings(new Pic.PicParts(originalInput, cleanedInput, birthDatePart, sign, individualNumber, controlCharacter));
    }

    private Pic.ValidationRule birthDatePartMustBeNumeric() {
        return this.birthDatePartMustBeNumeric;
    }

    private Pic.ValidationRule dayOfBirthDatePartMustBeInRangeOf1To31() {
        return this.dayOfBirthDatePartMustBeInRangeOf1To31;
    }

    private Pic.ValidationRule monthOfBirthDatePartMustBeInRangeOf1To12() {
        return this.monthOfBirthDatePartMustBeInRangeOf1To12;
    }

    private Pic.ValidationRule signMustHaveAcceptableValue() {
        return this.signMustHaveAcceptableValue;
    }

    private Pic.ValidationRule individualNumberMustBeNumeric() {
        return this.individualNumberMustBeNumeric;
    }

    private List<Pic.ValidationRule> validationRules() {
        return this.validationRules;
    }

    private Either<String, Pic> createFromSubstrings(Pic.PicParts pp) {
        Left left;
        Option failedValidationRule = this.validationRules().find((Function1 & Serializable & scala.Serializable)vr -> BoxesRunTime.boxToBoolean((boolean)Pic$.$anonfun$createFromSubstrings$1(pp, vr)));
        Option option = failedValidationRule;
        if (option instanceof Some) {
            Some some = (Some)option;
            Pic.ValidationRule rule = (Pic.ValidationRule)some.value();
            left = package$.MODULE$.Left().apply(rule.errorMessageGenerator().apply((Object)pp));
        } else if (None$.MODULE$.equals(option)) {
            left = this.createFromValidParts(pp);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private Either<String, Pic> createFromValidParts(Pic.PicParts pp) {
        Left left;
        char expectedControlCharacter = this.calculateExpectedControlCharacter(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(0).append(pp.birthDatePart()).append(pp.individualNumber()).toString())).toLong());
        if (pp.controlCharacter().charAt(0) != expectedControlCharacter) {
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(70).append("Invalid PIC: '").append(pp.originalInput()).append("'. The control character ('").append(pp.controlCharacter()).append("') is wrong: it should be '").append(expectedControlCharacter).append("'.").toString());
        } else {
            Right right;
            int n;
            Product gender = new StringOps(Predef$.MODULE$.augmentString(pp.individualNumber())).toInt() % 2 == 0 ? Female$.MODULE$ : Male$.MODULE$;
            char c = pp.sign().charAt(0);
            switch (c) {
                case '+': {
                    n = 1800;
                    break;
                }
                case '-': {
                    n = 1900;
                    break;
                }
                case 'A': {
                    n = 2000;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                }
            }
            int century = n;
            int yearWithinCentury = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(4, 6))).toInt();
            int birthYear = century + yearWithinCentury;
            int birthMonth = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(2, 4))).toInt();
            int birthDay = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(0, 2))).toInt();
            Pic candidate = new Pic(pp.cleanedInput(), (Gender)gender, birthYear, birthMonth, birthDay);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> candidate.birthDate());
            if (try_ instanceof Success) {
                right = package$.MODULE$.Right().apply((Object)candidate);
            } else if (try_ instanceof Failure) {
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(91).append("Invalid PIC: '").append(pp.originalInput()).append("'. The birth date is impossible, this day does not exist on the calendar: '").append(pp.birthDatePart()).append("'.").toString());
            } else {
                throw new MatchError((Object)try_);
            }
            left = right;
        }
        return left;
    }

    public char[] controlChars() {
        return this.controlChars;
    }

    public char calculateExpectedControlCharacter(long input) {
        int remainder = (int)(input % 31L);
        return this.controlChars()[remainder];
    }

    public static final /* synthetic */ boolean $anonfun$birthDatePartMustBeNumeric$1(Pic.PicParts pp) {
        return pp.birthDatePart().matches("\\d{6}");
    }

    public static final /* synthetic */ boolean $anonfun$dayOfBirthDatePartMustBeInRangeOf1To31$1(Pic.PicParts pp) {
        int day = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().substring(0, 2))).toInt();
        return day >= 1 && day <= 31;
    }

    public static final /* synthetic */ boolean $anonfun$monthOfBirthDatePartMustBeInRangeOf1To12$1(Pic.PicParts pp) {
        int month = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().substring(2, 4))).toInt();
        return month >= 1 && month <= 12;
    }

    public static final /* synthetic */ boolean $anonfun$signMustHaveAcceptableValue$1(Pic.PicParts pp) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'+', '-', 'A'})).contains((Object)BoxesRunTime.boxToCharacter((char)pp.sign().charAt(0)));
    }

    public static final /* synthetic */ boolean $anonfun$individualNumberMustBeNumeric$1(Pic.PicParts pp) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(pp.individualNumber())).toInt()).toOption().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createFromSubstrings$1(Pic.PicParts pp$2, Pic.ValidationRule vr) {
        return !BoxesRunTime.unboxToBoolean((Object)vr.predicate().apply((Object)pp$2));
    }

    private Pic$() {
        MODULE$ = this;
        this.finnishLegalAge = 18;
        this.birthDatePartMustBeNumeric = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)(Function1 & Serializable & scala.Serializable)pp -> BoxesRunTime.boxToBoolean((boolean)Pic$.$anonfun$birthDatePartMustBeNumeric$1(pp)), (Function1<Pic.PicParts, String>)(Function1 & Serializable & scala.Serializable)pp -> new StringBuilder(80).append("Invalid PIC: '").append(pp.originalInput()).append("'. The first six characters have to be numeric, but they were: '").append(pp.birthDatePart()).append("'.").toString());
        this.dayOfBirthDatePartMustBeInRangeOf1To31 = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)(Function1 & Serializable & scala.Serializable)pp -> BoxesRunTime.boxToBoolean((boolean)Pic$.$anonfun$dayOfBirthDatePartMustBeInRangeOf1To31$1(pp)), (Function1<Pic.PicParts, String>)(Function1 & Serializable & scala.Serializable)pp -> new StringBuilder(90).append("Invalid PIC: '").append(pp.originalInput()).append("'. The day part of the birth date is wrong: it should be 01-31, but was: '").append(pp.birthDatePart().substring(0, 2)).append("'.").toString());
        this.monthOfBirthDatePartMustBeInRangeOf1To12 = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)(Function1 & Serializable & scala.Serializable)pp -> BoxesRunTime.boxToBoolean((boolean)Pic$.$anonfun$monthOfBirthDatePartMustBeInRangeOf1To12$1(pp)), (Function1<Pic.PicParts, String>)(Function1 & Serializable & scala.Serializable)pp -> new StringBuilder(92).append("Invalid PIC: '").append(pp.originalInput()).append("'. The month part of the birth date is wrong: it should be 01-12, but was: '").append(pp.birthDatePart().substring(2, 4)).append("'.").toString());
        this.signMustHaveAcceptableValue = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)(Function1 & Serializable & scala.Serializable)pp -> BoxesRunTime.boxToBoolean((boolean)Pic$.$anonfun$signMustHaveAcceptableValue$1(pp)), (Function1<Pic.PicParts, String>)(Function1 & Serializable & scala.Serializable)pp -> new StringBuilder(76).append("Invalid PIC: '").append(pp.originalInput()).append("'. The sign (7th character) must be +, - or A, now it was: '").append(pp.sign()).append("'.").toString());
        this.individualNumberMustBeNumeric = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)(Function1 & Serializable & scala.Serializable)pp -> BoxesRunTime.boxToBoolean((boolean)Pic$.$anonfun$individualNumberMustBeNumeric$1(pp)), (Function1<Pic.PicParts, String>)(Function1 & Serializable & scala.Serializable)pp -> new StringBuilder(89).append("Invalid PIC: '").append(pp.originalInput()).append("'. The individual number (characters 8-10) must be numeric, now it was: '").append(pp.individualNumber()).append("'.").toString());
        this.validationRules = new .colon.colon((Object)this.birthDatePartMustBeNumeric(), (List)new .colon.colon((Object)this.dayOfBirthDatePartMustBeInRangeOf1To31(), (List)new .colon.colon((Object)this.monthOfBirthDatePartMustBeInRangeOf1To12(), (List)new .colon.colon((Object)this.signMustHaveAcceptableValue(), (List)new .colon.colon((Object)this.individualNumberMustBeNumeric(), (List)Nil$.MODULE$)))));
        this.controlChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};
    }
}

