/*
 * Decompiled with CFR 0.152.
 */
package org.fintrace.keycloak.events.service;

import org.fintrace.keycloak.events.service.EventReceiver;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventReceiver
implements EventReceiver {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventReceiver.class);

    @Override
    public void onEvent(Event event) {
        log.info("{} : {}", (Object)event.getRealmId(), (Object)event.getType().name());
    }

    @Override
    public void onAdminEvent(AdminEvent adminEvent) {
        log.info("{} : {} : {}", new Object[]{adminEvent.getRealmId(), adminEvent.getOperationType().name(), adminEvent.getRepresentation()});
    }

    protected abstract void onNewRealm();

    protected abstract void onRealmUpdate();

    protected abstract void onNewRole();

    protected abstract void onRoleUpdate();

    protected abstract void onNewGroup();

    protected abstract void onGroupUpdate();

    protected abstract void onNewUser();

    protected abstract void onUserUpdate();

    protected abstract void onUserAddedToRole();

    protected abstract void onUserAddedToGroup();

    protected abstract void onUserRemovedFromRole();

    protected abstract void onUserRemovedFromGroup();

    protected abstract void onUserLogin();

    protected abstract void onUserLoginFailed();

    protected abstract void onUserChangePassword();
}

