/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.solc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Solc {
    private static final Logger logger = LoggerFactory.getLogger(Solc.class);
    private File solc = null;

    public Solc(boolean sm) {
        try {
            this.initPropertyBundled();
            if (this.solc == null || !this.solc.exists()) {
                this.initDefaultBundled(sm);
            }
        }
        catch (IOException e) {
            logger.error(" Can't init solc compiler, e: ", (Throwable)e);
            throw new RuntimeException("Can't init solc compiler: ", e);
        }
    }

    private void initPropertyBundled() {
        String property = System.getProperty("solc.path", "");
        if (!"".equals(property)) {
            logger.info("initBundled from property, path: {}", (Object)property);
            this.solc = new File(property);
            this.solc.setExecutable(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDefaultBundled(boolean sm) throws IOException {
        File tmpDir = new File(System.getProperty("user.home"), ".fisco/solc/0.4.25/" + (sm ? "sm3" : "keccak256"));
        if (logger.isTraceEnabled()) {
            logger.trace(" sm: {}, tmpDir: {}", (Object)sm, (Object)tmpDir.getAbsolutePath());
        }
        tmpDir.mkdirs();
        String solcDir = this.getSolcDir(sm);
        try (InputStream is = this.getClass().getResourceAsStream(solcDir + "file.list");
             Scanner scanner = new Scanner(is);){
            while (scanner.hasNext()) {
                String s = scanner.next();
                File targetFile = new File(tmpDir, s);
                InputStream fis = this.getClass().getResourceAsStream(solcDir + s);
                try {
                    Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (this.solc != null) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace(" source: {}, destination: {}", (Object)(solcDir + s), (Object)targetFile.getAbsoluteFile());
                    }
                    this.solc = targetFile;
                    this.solc.setExecutable(true);
                    return;
                }
                finally {
                    if (fis == null) continue;
                    fis.close();
                }
            }
            return;
        }
    }

    private String getSolcDir(boolean sm) {
        String archName;
        String osName = this.getOS();
        String resourceDir = "/native/" + (sm ? "sm/" : "ecdsa/") + this.getOS() + "/";
        if ((osName.equals("linux") || osName.equals("mac")) && !(archName = this.getArch()).isEmpty()) {
            resourceDir = resourceDir + this.getArch();
            resourceDir = resourceDir + "/";
        }
        resourceDir = resourceDir + "solc/";
        return resourceDir;
    }

    private String getArch() {
        String archName = System.getProperty("os.arch", "");
        if (archName.contains("aarch64")) {
            return "arm";
        }
        return "";
    }

    private String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "win";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        throw new RuntimeException("Can't find solc compiler: unrecognized OS: " + osName);
    }

    public File getExecutable() {
        return this.solc;
    }
}

