/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.solc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Solc {
    private static final Logger logger = LoggerFactory.getLogger(Solc.class);
    private File solc = null;

    public Solc(boolean sm) {
        try {
            this.initBundled(sm);
        }
        catch (IOException e) {
            logger.debug(" Can't init solc compiler, sm: {}, error: {}, e: {}", new Object[]{sm, e.getMessage(), e});
            throw new RuntimeException("Can't init solc compiler: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initBundled(boolean sm) throws IOException {
        File tmpDir = new File(System.getProperty("user.home"), "solc/" + (sm ? "sm" : "ecdsa"));
        logger.debug(" sm: {}, tmpDir: {}", (Object)sm, (Object)tmpDir.getAbsolutePath());
        tmpDir.mkdirs();
        String solcFileDir = "/native/" + (sm ? "sm" : "ecdsa") + "/" + this.getOS() + "/solc/";
        try (InputStream is = this.getClass().getResourceAsStream(solcFileDir + "file.list");
             Scanner scanner = new Scanner(is);){
            while (scanner.hasNext()) {
                InputStream fis;
                block35: {
                    String s = scanner.next();
                    File targetFile = new File(tmpDir, s);
                    logger.debug(" targetFile: {}", (Object)targetFile.getAbsolutePath());
                    fis = this.getClass().getResourceAsStream(solcFileDir + s);
                    Throwable throwable = null;
                    try {
                        Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        if (this.solc == null) {
                            this.solc = targetFile;
                            this.solc.setExecutable(true);
                        }
                        if (fis == null) continue;
                        if (throwable == null) break block35;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fis == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fis.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fis.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fis.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fis.close();
            }
            return;
        }
    }

    private String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "win";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        throw new RuntimeException("Can't find solc compiler: unrecognized OS: " + osName);
    }

    public File getExecutable() {
        return this.solc;
    }
}

