/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.solc.compiler;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.fisco.solc.compiler.Solc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolidityCompiler {
    private static final Logger logger = LoggerFactory.getLogger(SolidityCompiler.class);
    private static SolidityCompiler INSTANCE;
    private Solc solc = new Solc(false);
    private Solc sMSolc = new Solc(true);

    public static Result compile(File source, boolean sm, boolean combinedJson, Option ... options) throws IOException {
        return SolidityCompiler.getInstance().compileSrc(source, sm, false, combinedJson, options);
    }

    public static Result compile(byte[] source, boolean sm, boolean combinedJson, Option ... options) throws IOException {
        return SolidityCompiler.getInstance().compileSrc(source, sm, false, combinedJson, options);
    }

    private Result compileSrc(File source, boolean sm, boolean optimize, boolean combinedJson, Option ... options) throws IOException {
        logger.debug(" source: {}, sm: {}", (Object)source.getAbsolutePath(), (Object)sm);
        Solc tmpSolc = this.getSolc(sm);
        List<String> commandParts = this.prepareCommandOptions(tmpSolc, optimize, combinedJson, options);
        commandParts.add(source.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(commandParts).directory(tmpSolc.getExecutable().getParentFile());
        processBuilder.environment().put("LD_LIBRARY_PATH", tmpSolc.getExecutable().getParentFile().getCanonicalPath());
        Process process = processBuilder.start();
        ParallelReader error = new ParallelReader(process.getErrorStream());
        ParallelReader output = new ParallelReader(process.getInputStream());
        error.start();
        output.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        boolean success = process.exitValue() == 0;
        logger.debug(" source file: {}, success: {}, output: {}, error: {} ", new Object[]{source.getAbsoluteFile(), success, output.getContent(), error.getContent()});
        return new Result(error.getContent(), output.getContent(), success);
    }

    private List<String> prepareCommandOptions(Solc solc, boolean optimize, boolean combinedJson, Option ... options) throws IOException {
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(solc.getExecutable().getCanonicalPath());
        if (optimize) {
            commandParts.add("--" + Options.OPTIMIZE.getName());
        }
        if (combinedJson) {
            Options.CombinedJson combinedJsonOption = new Options.CombinedJson(SolidityCompiler.getElementsOf(OutputOption.class, options));
            commandParts.add("--" + combinedJsonOption.getName());
            commandParts.add(combinedJsonOption.getValue());
        } else {
            for (Option option : SolidityCompiler.getElementsOf(OutputOption.class, options)) {
                commandParts.add("--" + option.getName());
            }
        }
        for (Option option : SolidityCompiler.getElementsOf(ListOption.class, options)) {
            commandParts.add("--" + option.getName());
            commandParts.add(option.getValue());
        }
        for (Option option : SolidityCompiler.getElementsOf(CustomOption.class, options)) {
            commandParts.add("--" + option.getName());
            if (option.getValue() == null) continue;
            commandParts.add(option.getValue());
        }
        return commandParts;
    }

    private static <T> List<T> getElementsOf(Class<T> clazz, Option ... options) {
        return Arrays.stream(options).filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    private Result compileSrc(byte[] source, boolean sm, boolean optimize, boolean combinedJson, Option ... options) throws IOException {
        Solc tmpSolc = SolidityCompiler.getInstance().getSolc(sm);
        List<String> commandParts = this.prepareCommandOptions(tmpSolc, optimize, combinedJson, options);
        ProcessBuilder processBuilder = new ProcessBuilder(commandParts).directory(tmpSolc.getExecutable().getParentFile());
        processBuilder.environment().put("LD_LIBRARY_PATH", tmpSolc.getExecutable().getParentFile().getCanonicalPath());
        Process process = processBuilder.start();
        try (BufferedOutputStream stream = new BufferedOutputStream(process.getOutputStream());){
            stream.write(source);
        }
        ParallelReader error = new ParallelReader(process.getErrorStream());
        ParallelReader output = new ParallelReader(process.getInputStream());
        error.start();
        output.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        boolean success = process.exitValue() == 0;
        return new Result(error.getContent(), output.getContent(), success);
    }

    public static String runGetVersionOutput(boolean sm) throws IOException {
        ArrayList<String> commandParts = new ArrayList<String>();
        Solc tmpSolc = SolidityCompiler.getInstance().getSolc(sm);
        commandParts.add(tmpSolc.getExecutable().getCanonicalPath());
        commandParts.add("--" + Options.VERSION.getName());
        ProcessBuilder processBuilder = new ProcessBuilder(commandParts).directory(tmpSolc.getExecutable().getParentFile());
        processBuilder.environment().put("LD_LIBRARY_PATH", tmpSolc.getExecutable().getParentFile().getCanonicalPath());
        Process process = processBuilder.start();
        ParallelReader error = new ParallelReader(process.getErrorStream());
        ParallelReader output = new ParallelReader(process.getInputStream());
        error.start();
        output.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (process.exitValue() == 0) {
            return output.getContent();
        }
        throw new RuntimeException("Problem getting solc version: " + error.getContent());
    }

    private Solc getSolc(boolean sm) {
        return sm ? this.sMSolc : this.solc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SolidityCompiler getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SolidityCompiler> clazz = SolidityCompiler.class;
        synchronized (SolidityCompiler.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SolidityCompiler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static class ParallelReader
    extends Thread {
        private InputStream stream;
        private StringBuilder content = new StringBuilder();

        ParallelReader(InputStream stream) {
            this.stream = stream;
        }

        public String getContent() {
            return this.getContent(true);
        }

        public synchronized String getContent(boolean waitForComplete) {
            if (waitForComplete) {
                while (this.stream != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
            return this.content.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.content.append(line).append("\n");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                ParallelReader parallelReader = this;
                synchronized (parallelReader) {
                    this.stream = null;
                    this.notifyAll();
                }
            }
        }
    }

    public static class Result {
        private String errors;
        private String output;
        private boolean success;

        public Result(String errors, String output, boolean success) {
            this.errors = errors;
            this.output = output;
            this.success = success;
        }

        public boolean isFailed() {
            return !this.success;
        }

        public String getErrors() {
            return this.errors;
        }

        public void setErrors(String errors) {
            this.errors = errors;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }
    }

    public static class CustomOption
    implements Option {
        private String name;
        private String value;

        public CustomOption(String name) {
            this.name = name.startsWith("--") ? name.substring(2) : name;
        }

        public CustomOption(String name, String value) {
            this(name);
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static enum OutputOption implements Option
    {
        AST("ast"),
        BIN("bin"),
        INTERFACE("interface"),
        ABI("abi"),
        METADATA("metadata"),
        ASTJSON("ast-json");

        private String name;

        private OutputOption(String name) {
            this.name = name;
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum NameOnlyOption implements Option
    {
        OPTIMIZE("optimize"),
        VERSION("version");

        private String name;

        private NameOnlyOption(String name) {
            this.name = name;
        }

        @Override
        public String getValue() {
            return "";
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ListOption
    implements Option {
        private String name;
        private List values;

        private ListOption(String name, List values) {
            this.name = name;
            this.values = values;
        }

        @Override
        public String getValue() {
            StringBuilder result = new StringBuilder();
            for (Object value : this.values) {
                if (OutputOption.class.isAssignableFrom(value.getClass())) {
                    result.append(result.length() == 0 ? ((OutputOption)value).getName() : ',' + ((OutputOption)value).getName());
                    continue;
                }
                if (Path.class.isAssignableFrom(value.getClass())) {
                    result.append(result.length() == 0 ? ((Path)value).toAbsolutePath().toString() : ',' + ((Path)value).toAbsolutePath().toString());
                    continue;
                }
                if (File.class.isAssignableFrom(value.getClass())) {
                    result.append(result.length() == 0 ? ((File)value).getAbsolutePath() : ',' + ((File)value).getAbsolutePath());
                    continue;
                }
                if (String.class.isAssignableFrom(value.getClass())) {
                    result.append(result.length() == 0 ? value : "," + value);
                    continue;
                }
                throw new UnsupportedOperationException("Unexpected type, value '" + value + "' cannot be retrieved.");
            }
            return result.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Option
    extends Serializable {
        public String getValue();

        public String getName();
    }

    public static final class Options {
        public static final OutputOption AST = OutputOption.AST;
        public static final OutputOption BIN = OutputOption.BIN;
        public static final OutputOption INTERFACE = OutputOption.INTERFACE;
        public static final OutputOption ABI = OutputOption.ABI;
        public static final OutputOption METADATA = OutputOption.METADATA;
        public static final OutputOption ASTJSON = OutputOption.ASTJSON;
        private static final NameOnlyOption OPTIMIZE = NameOnlyOption.OPTIMIZE;
        private static final NameOnlyOption VERSION = NameOnlyOption.VERSION;

        public static class AllowPaths
        extends ListOption {
            public AllowPaths(List values) {
                super("allow-paths", values);
            }
        }

        private static class CombinedJson
        extends ListOption {
            private CombinedJson(List values) {
                super("combined-json", values);
            }
        }
    }
}

