/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.solc.compiler;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilationResult {
    private static final Logger logger = LoggerFactory.getLogger(CompilationResult.class);
    private Map<String, ContractMetadata> contracts = Collections.emptyMap();
    public String version = "";

    public static CompilationResult parse(String rawJson) throws IOException {
        logger.debug("rawJson: {}", (Object)rawJson);
        if (rawJson == null || rawJson.isEmpty()) {
            CompilationResult empty = new CompilationResult();
            empty.contracts = Collections.emptyMap();
            empty.version = "";
            return empty;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonObject jsonObject = JsonParser.parseString((String)rawJson).getAsJsonObject();
        JsonObject result = new JsonObject();
        JsonObject asJsonObject = jsonObject.get("contracts").getAsJsonObject();
        Set contractNameList = asJsonObject.keySet();
        Object[] contractName = contractNameList.toArray();
        JsonObject contractObject = new JsonObject();
        for (Object contract : contractName) {
            JsonObject contractJsonObject = asJsonObject.get(contract.toString()).getAsJsonObject();
            JsonObject abiObject = new JsonObject();
            abiObject.addProperty("abi", contractJsonObject.get("abi").toString());
            abiObject.addProperty("bin", contractJsonObject.get("bin").getAsString());
            abiObject.addProperty("metadata", contractJsonObject.get("metadata").getAsString());
            contractObject.add(contract.toString(), (JsonElement)abiObject);
        }
        result.add("contracts", (JsonElement)contractObject);
        result.addProperty("version", jsonObject.get("version").getAsString());
        return (CompilationResult)objectMapper.readValue(result.toString(), CompilationResult.class);
    }

    public ContractMetadata getContract(String contractName) {
        for (Map.Entry<String, ContractMetadata> entry : this.contracts.entrySet()) {
            String key = entry.getKey();
            String name = key.substring(key.lastIndexOf(58) + 1);
            if (!contractName.equals(name)) continue;
            return entry.getValue();
        }
        throw new UnsupportedOperationException("No contract found with name '" + contractName + "'. Please specify a valid contract name. Available keys (" + this.getContractKeys() + ").");
    }

    public ContractMetadata getContract(Path contractPath, String contractName) {
        return this.contracts.get(contractPath.toAbsolutePath().toString() + ':' + contractName);
    }

    public List<ContractMetadata> getContracts() {
        return new ArrayList<ContractMetadata>(this.contracts.values());
    }

    public List<String> getContractKeys() {
        return new ArrayList<String>(this.contracts.keySet());
    }

    public static class ContractMetadata {
        public String abi;
        public String bin;
        public String metadata;

        public String toString() {
            return "ContractMetadata [abi=" + this.abi + ", bin=" + this.bin + ", metadata=" + this.metadata + "]";
        }
    }
}

