/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.solc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Solc {
    private static final Logger logger = LoggerFactory.getLogger(Solc.class);
    private File solc = null;

    public Solc(boolean sm) {
        try {
            this.initPropertyBundled(sm);
            if (this.solc == null || !this.solc.exists()) {
                this.initDefaultBundled(sm);
            }
        }
        catch (IOException e) {
            logger.error(" Can't init solc compiler, e: ", (Throwable)e);
            throw new RuntimeException("Can't init solc compiler: ", e);
        }
    }

    private void initPropertyBundled(boolean sm) {
        String propertyName = sm ? "solc.path" : "smsolc.path";
        String propertyValue = System.getProperty(propertyName, "");
        if (!"".equals(propertyValue)) {
            logger.info("initBundled from property, propertyName: {}, propertyValue: {}", (Object)propertyName, (Object)propertyValue);
            this.solc = new File(propertyValue);
            this.solc.setExecutable(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDefaultBundled(boolean sm) throws IOException {
        File tmpDir = new File(System.getProperty("user.home"), ".fisco/solc/0.8.11/" + (sm ? "sm3" : "keccak256"));
        if (logger.isTraceEnabled()) {
            logger.trace(" sm: {}, tmpDir: {}", (Object)sm, (Object)tmpDir.getAbsolutePath());
        }
        tmpDir.mkdirs();
        String solcDir = this.getSolcDir(sm);
        try (InputStream is = this.getClass().getResourceAsStream(solcDir + "file.list");
             Scanner scanner = new Scanner(is);){
            while (scanner.hasNext()) {
                Throwable throwable;
                InputStream fis;
                block39: {
                    block40: {
                        String s = scanner.next();
                        File targetFile = new File(tmpDir, s);
                        fis = this.getClass().getResourceAsStream(solcDir + s);
                        throwable = null;
                        try {
                            Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            if (this.solc != null) break block39;
                            if (logger.isTraceEnabled()) {
                                logger.trace(" source: {}, destination: {}", (Object)(solcDir + s), (Object)targetFile.getAbsoluteFile());
                            }
                            this.solc = targetFile;
                            this.solc.setExecutable(true);
                            if (fis == null) return;
                            if (throwable == null) break block40;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (fis == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        fis.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                fis.close();
                                throw throwable3;
                            }
                        }
                        try {
                            fis.close();
                            return;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            return;
                        }
                    }
                    fis.close();
                    return;
                }
                if (fis == null) continue;
                if (throwable != null) {
                    try {
                        fis.close();
                        continue;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        continue;
                    }
                }
                fis.close();
            }
            return;
        }
    }

    private String getSolcDir(boolean sm) {
        String archName;
        String osName = this.getOS();
        String resourceDir = "/native/" + (sm ? "sm/" : "ecdsa/") + this.getOS() + "/";
        if (osName.equals("linux") && !(archName = this.getArch()).isEmpty()) {
            resourceDir = resourceDir + this.getArch();
            resourceDir = resourceDir + "/";
        }
        resourceDir = resourceDir + "solc/";
        return resourceDir;
    }

    private String getArch() {
        String archName = System.getProperty("os.arch", "");
        if (archName.contains("aarch64")) {
            return "arm";
        }
        return "";
    }

    private String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "win";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        throw new RuntimeException("Can't find solc compiler: unrecognized OS: " + osName);
    }

    public File getExecutable() {
        return this.solc;
    }
}

