/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.examples.performance;

import org.fishwife.jrugged.PerformanceMonitor;
import org.fishwife.jrugged.examples.performance.FixedDelayPerformer;
import org.fishwife.jrugged.examples.performance.OccasionalExceptionPerformer;

public class InstrumentationImpact {
    public static void main(String[] args) throws Exception {
        InstrumentationImpact ii = new InstrumentationImpact();
        ii.examplePerformanceImpact();
        ii.exampleExceptionCountsImpact();
        ii.exampleRunningSuccessRPS();
    }

    public void examplePerformanceImpact() throws Exception {
        PerformanceMonitor perfMon = new PerformanceMonitor();
        FixedDelayPerformer performer = new FixedDelayPerformer(Long.valueOf(50L));
        long startDelay = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            perfMon.invoke((Runnable)performer);
        }
        long endDelay = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            performer.run();
        }
        long end = System.currentTimeMillis();
        long deltaDelay = endDelay - startDelay;
        long delta = end - start;
        long difference = deltaDelay - delta;
        long percentEffect = difference / delta * 100L;
        System.out.println("PerfMon Runtime Total: " + deltaDelay);
        System.out.println("Plain Runtime Total: " + delta);
        System.out.println(String.format("Instrumentation Effect: %s, Difference Percent: %s", difference, percentEffect));
    }

    public void exampleExceptionCountsImpact() {
        int i;
        int numberOfTimesToTryAMethodCall = 500;
        int numberOfAttemptsBeforeThrowingException = 5;
        int expectedNumberOfFailures = numberOfTimesToTryAMethodCall / numberOfAttemptsBeforeThrowingException;
        int expectedNumberOfSuccess = numberOfTimesToTryAMethodCall - expectedNumberOfFailures;
        PerformanceMonitor perfMon = new PerformanceMonitor();
        OccasionalExceptionPerformer performer = new OccasionalExceptionPerformer(numberOfAttemptsBeforeThrowingException);
        for (i = 0; i < numberOfTimesToTryAMethodCall; ++i) {
            try {
                perfMon.invoke((Runnable)performer);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < numberOfTimesToTryAMethodCall; ++i) {
            try {
                performer.run();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.println("Performance Counter Failures: " + perfMon.getFailureCount() + " Expected Failure Count is: " + expectedNumberOfFailures);
        System.out.println("Performance Counter Success: " + perfMon.getSuccessCount() + " Expected Success Count is: " + expectedNumberOfSuccess);
    }

    public void exampleRunningSuccessRPS() throws Exception {
        PerformanceMonitor perfMon = new PerformanceMonitor();
        FixedDelayPerformer performer = new FixedDelayPerformer(Long.valueOf(10L));
        long begin = System.currentTimeMillis();
        int counter = 0;
        while (System.currentTimeMillis() - begin < 60000L) {
            ++counter;
            perfMon.invoke((Runnable)performer);
        }
        System.out.println("Counter: " + counter);
        System.out.println("Success rate last minute: " + perfMon.getSuccessRequestsPerSecondLastMinute());
        System.out.println("Success rate last hour: " + perfMon.getSuccessRequestsPerSecondLastHour());
        System.out.println("Success rate last day: " + perfMon.getSuccessRequestsPerSecondLastDay());
        System.out.println("Success rate last lifetime: " + perfMon.getSuccessRequestsPerSecondLifetime());
    }
}

