/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.examples.webapp;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fishwife.jrugged.PerformanceMonitor;
import org.fishwife.jrugged.PerformanceMonitorFactory;
import org.fishwife.jrugged.aspects.PerformanceMonitorAspect;
import org.fishwife.jrugged.examples.AspectResponseTweaker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AspectPerformanceMonitorExample {
    @Autowired
    private PerformanceMonitorAspect performanceAspect;
    @Autowired
    private AspectResponseTweaker aspectResponseTweaker;

    public PerformanceMonitorAspect getPerformanceAspect() {
        return this.performanceAspect;
    }

    public void setPerformanceAspect(PerformanceMonitorAspect performanceAspect) {
        this.performanceAspect = performanceAspect;
    }

    public AspectResponseTweaker getResponseTweaker() {
        return this.aspectResponseTweaker;
    }

    public void setAspectResponseTweaker(AspectResponseTweaker aspectResponseTweaker) {
        this.aspectResponseTweaker = aspectResponseTweaker;
    }

    @RequestMapping(value={"/aspectPerformanceMonitor"})
    public ModelAndView viewMain(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delayedFor = this.aspectResponseTweaker.delay();
        ModelAndView view = new ModelAndView("aspectPerf-monitor");
        view.addObject("delay", (Object)new Integer(delayedFor));
        return view;
    }

    @RequestMapping(value={"/aspectPerformanceMonitor/stats"})
    public ModelAndView viewPerformanceMonitor(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuilder sb = new StringBuilder();
        PerformanceMonitorFactory factory = this.performanceAspect.getPerformanceMonitorFactory();
        for (String monitorName : factory.getPerformanceMonitorNames()) {
            Method[] methods;
            PerformanceMonitor m = factory.findPerformanceMonitor(monitorName);
            sb.append(String.format("[%s]", monitorName)).append("\n");
            for (Method monitorMethod : methods = m.getClass().getMethods()) {
                if (!monitorMethod.getName().startsWith("get")) continue;
                sb.append(String.format("\t%s: %s\n", monitorMethod.getName().substring(3), monitorMethod.invoke((Object)m, new Object[0])));
            }
            sb.append("\n");
        }
        response.setContentType("text/plain");
        response.getWriter().println(sb.toString());
        return null;
    }
}

