/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.httpclient;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpClientDecorator
implements HttpClient {
    protected HttpClient backend;

    public AbstractHttpClientDecorator(HttpClient backend) {
        this.backend = backend;
    }

    public abstract HttpResponse execute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    protected HttpHost getHttpHost(HttpUriRequest req) {
        URI uri = req.getURI();
        String scheme = uri.getScheme();
        if ("HTTPS".equalsIgnoreCase(scheme)) {
            return new HttpHost(uri.getScheme() + "://" + uri.getAuthority());
        }
        return new HttpHost(uri.getAuthority());
    }

    public HttpResponse execute(HttpUriRequest req) throws IOException, ClientProtocolException {
        return this.execute(req, (HttpContext)null);
    }

    public HttpResponse execute(HttpUriRequest req, HttpContext ctx) throws IOException, ClientProtocolException {
        return this.execute(this.getHttpHost(req), (HttpRequest)req, ctx);
    }

    public HttpResponse execute(HttpHost host, HttpRequest req) throws IOException, ClientProtocolException {
        return this.execute(host, req, (HttpContext)null);
    }

    public <T> T execute(HttpUriRequest req, ResponseHandler<? extends T> rh) throws IOException, ClientProtocolException {
        return (T)rh.handleResponse(this.execute(req));
    }

    public <T> T execute(HttpUriRequest req, ResponseHandler<? extends T> rh, HttpContext ctx) throws IOException, ClientProtocolException {
        return (T)rh.handleResponse(this.execute(req, ctx));
    }

    public <T> T execute(HttpHost host, HttpRequest req, ResponseHandler<? extends T> rh) throws IOException, ClientProtocolException {
        return (T)rh.handleResponse(this.execute(host, req));
    }

    public <T> T execute(HttpHost host, HttpRequest req, ResponseHandler<? extends T> rh, HttpContext ctx) throws IOException, ClientProtocolException {
        return (T)rh.handleResponse(this.execute(host, req, ctx));
    }

    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.backend.getParams();
    }
}

