/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged.httpclient;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.fishwife.jrugged.httpclient.AbstractHttpClientDecorator;
import org.fishwife.jrugged.httpclient.DefaultResponseFailureAssessor;
import org.fishwife.jrugged.httpclient.ResponseFailureAssessor;
import org.fishwife.jrugged.httpclient.UnsuccessfulResponseException;

public class FailureExposingHttpClient
extends AbstractHttpClientDecorator {
    private ResponseFailureAssessor assessor;

    public FailureExposingHttpClient(HttpClient backend) {
        super(backend);
        this.assessor = new DefaultResponseFailureAssessor();
    }

    public FailureExposingHttpClient(HttpClient backend, ResponseFailureAssessor assessor) {
        super(backend);
        this.assessor = assessor;
    }

    public HttpResponse execute(HttpHost host, HttpRequest req, HttpContext ctx) throws IOException, ClientProtocolException {
        HttpResponse resp = this.backend.execute(host, req, ctx);
        if (this.assessor.isFailure(resp)) {
            throw new UnsuccessfulResponseException(resp);
        }
        return resp;
    }
}

