/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import java.util.function.BiConsumer;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LoggerAtLevel {
    private final BiConsumer<String, Throwable> messageThrowableConsumer;
    private Throwable cause;

    public LoggerAtLevel(BiConsumer<String, Throwable> messageThrowableConsumer) {
        this.messageThrowableConsumer = messageThrowableConsumer;
    }

    public LoggerAtLevel withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public void log(String message) {
        this.messageThrowableConsumer.accept(message, this.cause);
    }

    public void log(String format, Object arg) {
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg);
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    public void log(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    public void log(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }
}

