/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import org.fissore.slf4j.LoggerAtLevel;
import org.fissore.slf4j.NOOPLogger;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class FluentLogger {
    private static final NOOPLogger NOOP_LOGGER = new NOOPLogger();
    private final Logger logger;
    private final boolean isLocationAwareLogger;

    public FluentLogger(Logger logger) {
        this.logger = logger;
        this.isLocationAwareLogger = logger instanceof LocationAwareLogger;
    }

    public LoggerAtLevel info() {
        if (!this.logger.isInfoEnabled()) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).info(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 20);
    }

    public LoggerAtLevel info(Marker marker) {
        if (!this.logger.isInfoEnabled(marker)) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).info(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 20).withMarker(marker);
    }

    public LoggerAtLevel debug() {
        if (!this.logger.isDebugEnabled()) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).debug(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 10);
    }

    public LoggerAtLevel debug(Marker marker) {
        if (!this.logger.isDebugEnabled(marker)) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).debug(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 20).withMarker(marker);
    }

    public LoggerAtLevel error() {
        if (!this.logger.isErrorEnabled()) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).error(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 40);
    }

    public LoggerAtLevel error(Marker marker) {
        if (!this.logger.isErrorEnabled(marker)) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).error(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 40).withMarker(marker);
    }

    public LoggerAtLevel trace() {
        if (!this.logger.isTraceEnabled()) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).trace(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 0);
    }

    public LoggerAtLevel trace(Marker marker) {
        if (!this.logger.isTraceEnabled(marker)) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).trace(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 0).withMarker(marker);
    }

    public LoggerAtLevel warn() {
        if (!this.logger.isWarnEnabled()) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 30);
    }

    public LoggerAtLevel warn(Marker marker) {
        if (!this.logger.isWarnEnabled(marker)) {
            return NOOP_LOGGER;
        }
        return new LoggerAtLevel((arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1), this.isLocationAwareLogger, this.logger, 30).withMarker(marker);
    }
}

