/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.fissore.slf4j.LoggerStats;
import org.fissore.slf4j.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class LoggerAtLevel {
    private static final String FQCN = LoggerAtLevel.class.getName();
    private static final LoggerStats LOGGER_STATS = new LoggerStats();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final BiConsumer<String, Object[]> loggerMethod;
    private final TriConsumer<Marker, String, Object[]> loggerMethodWithMarker;
    private final boolean isLocationAwareLogger;
    private final Logger logger;
    private final int level;
    private Throwable cause;
    private Marker marker;
    private LogEveryAmountOfTime logEveryAmountOfTime;
    private LogEveryNumberOfCalls logEveryNumberOfCalls;

    public LoggerAtLevel(BiConsumer<String, Object[]> loggerMethod, TriConsumer<Marker, String, Object[]> loggerMethodWithMarker, boolean isLocationAwareLogger, Logger logger, int level) {
        this.loggerMethod = loggerMethod;
        this.loggerMethodWithMarker = loggerMethodWithMarker;
        this.isLocationAwareLogger = isLocationAwareLogger;
        this.logger = logger;
        this.level = level;
    }

    public LoggerAtLevel withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public LoggerAtLevel withMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    public LoggerAtLevel every(long amountOfTime, ChronoUnit unit) {
        if (this.logEveryNumberOfCalls != null) {
            throw new IllegalStateException("We cannot filter log by time frame AND number of calls: pick one please");
        }
        this.logEveryAmountOfTime = new LogEveryAmountOfTime(amountOfTime, unit);
        return this;
    }

    public LoggerAtLevel every(int amountOfCalls) {
        if (this.logEveryAmountOfTime != null) {
            throw new IllegalStateException("We cannot filter log by time frame AND number of calls: pick one please");
        }
        this.logEveryNumberOfCalls = new LogEveryNumberOfCalls(amountOfCalls);
        return this;
    }

    public void log(String message) {
        this.logInternal(message, EMPTY_ARRAY);
    }

    public void log(Supplier<String> messageSupplier) {
        this.logInternal(messageSupplier.get(), EMPTY_ARRAY);
    }

    public void log(String format, Object arg) {
        this.logInternal(format, new Object[]{arg});
    }

    public void log(Supplier<String> formatSupplier, Object arg) {
        this.logInternal(formatSupplier.get(), new Object[]{arg});
    }

    public void log(String format, Object arg1, Object arg2) {
        this.logInternal(format, new Object[]{arg1, arg2});
    }

    public void log(Supplier<String> formatSupplier, Object arg1, Object arg2) {
        this.logInternal(formatSupplier.get(), new Object[]{arg1, arg2});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3});
    }

    public void log(Supplier<String> formatSupplier, Object arg1, Object arg2, Object arg3) {
        this.logInternal(formatSupplier.get(), new Object[]{arg1, arg2, arg3});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3, arg4});
    }

    public void log(Supplier<String> formatSupplier, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.logInternal(formatSupplier.get(), new Object[]{arg1, arg2, arg3, arg4});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public void log(Supplier<String> formatSupplier, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.logInternal(formatSupplier.get(), new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public void log(String format, Object ... args) {
        this.logInternal(format, args);
    }

    public void log(Supplier<String> formatSupplier, Object ... args) {
        this.logInternal(formatSupplier.get(), args);
    }

    private void logInternal(String format, Object[] args) {
        if (this.logEveryAmountOfTime != null || this.logEveryNumberOfCalls != null) {
            String caller = this.getCaller();
            if (this.logEveryNumberOfCalls != null && !LOGGER_STATS.recordCallThenCheckIfNumberOfCallsMatchesAmount(caller, this.logEveryNumberOfCalls.amount)) {
                return;
            }
            if (this.logEveryAmountOfTime != null && !LOGGER_STATS.recordCallAndCheckIfEnoughTimePassed(caller, this.logEveryAmountOfTime.amount, this.logEveryAmountOfTime.unit)) {
                return;
            }
        }
        args = this.toStrings(args);
        if (this.isLocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(this.marker, FQCN, this.level, format, args, this.cause);
        } else {
            Object[] newArgs = args;
            if (this.cause != null) {
                newArgs = new Object[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[newArgs.length - 1] = this.cause;
            }
            if (this.marker != null) {
                this.loggerMethodWithMarker.accept(this.marker, format, newArgs);
            } else {
                this.loggerMethod.accept(format, newArgs);
            }
        }
    }

    private String getCaller() {
        return Arrays.stream(new Throwable().getStackTrace()).filter(trace -> !trace.getClassName().startsWith(LoggerAtLevel.class.getPackage().getName())).findFirst().map(trace -> trace.getClassName() + ":" + trace.getMethodName() + ":" + trace.getLineNumber()).orElseThrow(IllegalStateException::new);
    }

    private Object toString(Object arg) {
        if (arg instanceof Supplier) {
            arg = this.toString(((Supplier)arg).get());
        }
        return arg;
    }

    private Object[] toStrings(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toString(args[i]);
        }
        return args;
    }

    private static class LogEveryNumberOfCalls {
        private final int amount;

        public LogEveryNumberOfCalls(int amount) {
            this.amount = amount;
        }
    }

    private static class LogEveryAmountOfTime {
        private final long amount;
        private final ChronoUnit unit;

        public LogEveryAmountOfTime(long amount, ChronoUnit unit) {
            this.amount = amount;
            this.unit = unit;
        }
    }
}

