/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LoggerAtLevel {
    private final Supplier<Boolean> levelEnabled;
    private final BiConsumer<String, Throwable> messageThrowableConsumer;
    private Throwable cause;

    public LoggerAtLevel(Supplier<Boolean> levelEnabled, BiConsumer<String, Throwable> messageThrowableConsumer) {
        this.levelEnabled = levelEnabled;
        this.messageThrowableConsumer = messageThrowableConsumer;
    }

    public LoggerAtLevel withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public void log(String message) {
        this.messageThrowableConsumer.accept(message, this.cause);
    }

    public void log(String format, Object arg) {
        if (!this.levelEnabled.get().booleanValue()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)this.toString(arg));
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    public void log(String format, Object arg1, Object arg2) {
        if (!this.levelEnabled.get().booleanValue()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.format((String)format, (Object)this.toString(arg1), (Object)this.toString(arg2));
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    public void log(String format, Object ... args) {
        if (!this.levelEnabled.get().booleanValue()) {
            return;
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])this.toStrings(args));
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    private Object toString(Object arg) {
        if (arg instanceof Supplier) {
            arg = this.toString(((Supplier)arg).get());
        }
        return arg;
    }

    private Object[] toStrings(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toString(args[i]);
        }
        return args;
    }
}

