/*
 * Decompiled with CFR 0.152.
 */
package org.fissore.slf4j;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.fissore.slf4j.LoggerStats;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LoggerAtLevel {
    private static final LoggerStats LOGGER_STATS = new LoggerStats();
    private final BiConsumer<String, Throwable> messageThrowableConsumer;
    private Throwable cause;
    private LogEveryAmountOfTime logEveryAmountOfTime;
    private LogEveryNumberOfCalls logEveryNumberOfCalls;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public LoggerAtLevel(BiConsumer<String, Throwable> messageThrowableConsumer) {
        this.messageThrowableConsumer = messageThrowableConsumer;
    }

    public LoggerAtLevel withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public LoggerAtLevel every(long amountOfTime, ChronoUnit unit) {
        if (this.logEveryNumberOfCalls != null) {
            throw new IllegalStateException("You cannot filter log by time frame AND number of calls: you must pick one");
        }
        this.logEveryAmountOfTime = new LogEveryAmountOfTime(amountOfTime, unit);
        return this;
    }

    public LoggerAtLevel every(int amountOfCalls) {
        if (this.logEveryAmountOfTime != null) {
            throw new IllegalStateException("You cannot filter log by time frame AND number of calls: you must pick one");
        }
        this.logEveryNumberOfCalls = new LogEveryNumberOfCalls(amountOfCalls);
        return this;
    }

    public void log(String message) {
        this.logInternal(message, EMPTY_ARRAY);
    }

    public void log(String format, Object arg) {
        this.logInternal(format, new Object[]{arg});
    }

    public void log(String format, Object arg1, Object arg2) {
        this.logInternal(format, new Object[]{arg1, arg2});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3, arg4});
    }

    public void log(String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this.logInternal(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public void log(String format, Object ... args) {
        this.logInternal(format, args);
    }

    private void logInternal(String format, Object[] args) {
        if (this.logEveryAmountOfTime != null || this.logEveryNumberOfCalls != null) {
            String caller = this.getCaller();
            if (this.logEveryNumberOfCalls != null && !LOGGER_STATS.recordCallThenCheckIfNumberOfCallsMatchesAmount(caller, this.logEveryNumberOfCalls.amount)) {
                return;
            }
            if (this.logEveryAmountOfTime != null && !LOGGER_STATS.recordCallAndCheckIfEnoughTimePassed(caller, this.logEveryAmountOfTime.amount, this.logEveryAmountOfTime.unit)) {
                return;
            }
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])this.toStrings(args));
        this.messageThrowableConsumer.accept(ft.getMessage(), this.cause);
    }

    private String getCaller() {
        return Arrays.stream(new Throwable().getStackTrace()).filter(trace -> !trace.getClassName().startsWith(LoggerAtLevel.class.getPackage().getName())).findFirst().map(trace -> trace.getClassName() + ":" + trace.getMethodName() + ":" + trace.getLineNumber()).orElseThrow(IllegalStateException::new);
    }

    private Object toString(Object arg) {
        if (arg instanceof Supplier) {
            arg = this.toString(((Supplier)arg).get());
        }
        return arg;
    }

    private Object[] toStrings(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toString(args[i]);
        }
        return args;
    }

    private static class LogEveryNumberOfCalls {
        private final int amount;

        public LogEveryNumberOfCalls(int amount) {
            this.amount = amount;
        }
    }

    private static class LogEveryAmountOfTime {
        private final long amount;
        private final ChronoUnit unit;

        public LogEveryAmountOfTime(long amount, ChronoUnit unit) {
            this.amount = amount;
            this.unit = unit;
        }
    }
}

